% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{performance_metric}
\alias{performance_metric}
\title{Calculate metrics for model evaluation}
\usage{
performance_metric(
  pred,
  actual,
  positive,
  metric = c("ZeroOneLoss", "Accuracy", "Precision", "Recall", "Sensitivity",
    "Specificity", "F1_Score", "Fbeta_Score", "LogLoss", "AUC", "Gini", "PRAUC",
    "LiftAUC", "GainAUC", "KS_Stat", "ConfusionMatrix"),
  cutoff = 0.5,
  beta = 1
)
}
\arguments{
\item{pred}{numeric. Probability values that predicts the positive class of the target variable.}

\item{actual}{factor. The value of the actual target variable.}

\item{positive}{character. Level of positive class of binary classification.}

\item{metric}{character. The performance metrics you want to calculate. See details.}

\item{cutoff}{numeric. Threshold for classifying predicted probability values into positive and negative classes.}

\item{beta}{numeric. Weight of precision in harmonic mean for F-Beta Score.}
}
\value{
numeric or table object.
Confusion Matrix return by table object. and otherwise is numeric.:
The performance metrics calculated are as follows.:
\itemize{
\item ZeroOneLoss : Normalized Zero-One Loss(Classification Error Loss).
\item Accuracy : Accuracy.
\item Precision : Precision.
\item Recall : Recall.
\item Sensitivity : Sensitivity.
\item Specificity : Specificity.
\item F1_Score : F1 Score.
\item Fbeta_Score : F-Beta Score.
\item LogLoss : Log loss / Cross-Entropy Loss.
\item AUC : Area Under the Receiver Operating Characteristic Curve (ROC AUC).
\item Gini : Gini Coefficient.
\item PRAUC : Area Under the Precision-Recall Curve (PR AUC).
\item LiftAUC : Area Under the Lift Chart.
\item GainAUC : Area Under the Gain Chart.
\item KS_Stat : Kolmogorov-Smirnov Statistic.
\item ConfusionMatrix : Confusion Matrix.
}
}
\description{
Calculate some representative metrics for binary classification model evaluation.
}
\details{
The cutoff argument applies only if the metric argument is "ZeroOneLoss", "Accuracy", "Precision", "Recall",
"Sensitivity", "Specificity", "F1_Score", "Fbeta_Score", "ConfusionMatrix".
}
\examples{
\donttest{
library(dplyr)

# Divide the train data set and the test data set.
sb <- rpart::kyphosis \%>\%
  split_by(Kyphosis)

# Extract the train data set from original data set.
train <- sb \%>\%
  extract_set(set = "train")

# Extract the test data set from original data set.
test <- sb \%>\%
  extract_set(set = "test")

# Sampling for unbalanced data set using SMOTE(synthetic minority over-sampling technique).
train <- sb \%>\%
  sampling_target(seed = 1234L, method = "ubSMOTE")

# Cleaning the set.
train <- train \%>\%
  cleanse

# Run the model fitting.
result <- run_models(.data = train, target = "Kyphosis", positive = "present")
result

# Predict the model.
pred <- run_predict(result, test)
pred

# Calculate Accuracy.
performance_metric(attr(pred$predicted[[1]], "pred_prob"), test$Kyphosis,
  "present", "Accuracy")
# Calculate Confusion Matrix.
performance_metric(attr(pred$predicted[[1]], "pred_prob"), test$Kyphosis,
  "present", "ConfusionMatrix")
# Calculate Confusion Matrix by cutoff = 0.55.
performance_metric(attr(pred$predicted[[1]], "pred_prob"), test$Kyphosis,
  "present", "ConfusionMatrix", cutoff = 0.55)
}
   
}
