% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfg_csr_convert_df.r
\name{mfg_csr_convert_df}
\alias{mfg_csr_convert_df}
\title{Returns a CSR classification based on Morphofunctional group (MFG).
Correspondence based on Salmaso et al. 2015 and Reynolds et al. 1988}
\usage{
mfg_csr_convert_df(phyto.df, mfg)
}
\arguments{
\item{phyto.df}{dataframe containing a character field containing MFG classifications}

\item{mfg}{Character string with MFG name, following Salmaso et al. 2015}
}
\value{
A dataframe with an additional field named CSR, containing CSR classifications or NA
}
\description{
Returns a CSR classification based on Morphofunctional group (MFG).
Correspondence based on Salmaso et al. 2015 and Reynolds et al. 1988
}
\examples{

data(lakegeneva)
lakegeneva<-genus_species_extract(lakegeneva,'phyto_name')
lakegeneva<-species_to_mfg_df(lakegeneva)
lakegeneva<-mfg_csr_convert_df(lakegeneva,mfg='MFG')
head(lakegeneva)
}
