% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_balanco.R
\name{padronizar_balanco}
\alias{padronizar_balanco}
\title{Processa e agrega um balanco patrimonial em categorias contabeis}
\usage{
padronizar_balanco(df)
}
\arguments{
\item{df}{Um \code{data.frame} contendo o balanco patrimonial. A primeira coluna deve conter os nomes das contas,
e as colunas seguintes devem conter valores financeiros em formato de texto (ex: \code{"(1.234,56)"}).}
}
\value{
Uma lista com dois objetos:
\describe{
  \item{\code{agregado}}{Um \code{data.frame} com os valores agregados por categoria contabil.}
  \item{\code{original}}{O \code{data.frame} original com os valores convertidos e a nova coluna \code{Categoria}.}
}
}
\description{
Esta funcao realiza o pre-processamento de um data frame contendo contas do balanco patrimonial,
convertendo os valores numericos no formato brasileiro para formato numerico padrao do R,
classificando as contas em categorias contabeis predefinidas e agregando os valores por categoria.
}
\details{
A primeira coluna do data frame deve conter os nomes das contas, enquanto as demais colunas devem
conter os valores financeiros em formato textual brasileiro (com ponto como separador de milhar e virgula decimal).
}
\examples{
df <- data.frame(
  Conta = c("Caixa e equivalentes de caixa", "Fornecedores"),
  X2022 = c("1.000,00", "(500,00)"),
  X2023 = c("1.200,00", "(600,00)")
)

# Padronizando o balanço
resultado <- padronizar_balanco(df)
resultado$agregado

}
