% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_parsnip.R
\name{parsnip_model}
\alias{parsnip_model}
\title{Fit outcome models using \code{parsnip} models}
\usage{
parsnip_model(model_spec, save_path)
}
\arguments{
\item{model_spec}{A \code{parsnip} model definition with \code{mode = "classification"}.}

\item{save_path}{Directory to save models. Set to \code{NA} if models should not be saved.}
}
\value{
An object of class \code{te_parsnip_model} inheriting from \linkS4class{te_model_fitter} which is used for
dispatching methods for the fitting models.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Specify that the models should be fit using a classification model specified with the \code{parsnip} package.

Warning: This functionality is experimental and not recommended for use in analyses.
\eqn{sqrt{n}}-consistency estimation and valid inference of the parameters in marginal structural models for
emulated trials generally require that the weights for treatment switching and censoring be estimated at parametric
rates, which is generally not possible when using data-adaptive estimation of high-dimensional regressions.
Therefore, we only recommend using \code{\link[=stats_glm_logit]{stats_glm_logit()}}.
}
\examples{
\dontrun{
if (
  requireNamespace("parsnip", quietly = TRUE) &&
    requireNamespace("rpart", quietly = TRUE)
) {
  # Use a decision tree model fitted with the rpart package
  parsnip_model(
    model_spec = parsnip::decision_tree(tree_depth = 30) |>
      set_mode("classification") |>
      set_engine("rpart"),
    save_path = tempdir()
  )
}
}

}
\seealso{
Other model_fitter: 
\code{\link{stats_glm_logit}()},
\code{\link{te_model_fitter-class}}
}
\concept{model_fitter}
