% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_lm.R2.R
\name{p_lm.R2}
\alias{p_lm.R2}
\title{p-value from global linear regression model simulation}
\usage{
p_lm.R2(
  n,
  R2,
  k,
  R2_0 = 0,
  k.R2_0 = 0,
  R2.resid = 1 - R2,
  fixed = TRUE,
  return_analysis = FALSE,
  ...
)
}
\arguments{
\item{n}{sample size}

\item{R2}{R-squared effect size}

\item{k}{number of IVs}

\item{R2_0}{null hypothesis for R-squared}

\item{k.R2_0}{number of IVs associated with the null hypothesis model}

\item{R2.resid}{residual R-squared value, typically used when comparing
nested models when fit sequentially (e.g., comparing model A vs B when
model involves the structure A -> B -> C)}

\item{fixed}{logical; if FALSE then the data are random generated
according to a joint multivariate normal distribution}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
p-values associated with linear regression model using fixed/random
independent variables. Focus is on the omnibus behavior of the
R^2 statistic.
}
\examples{

# 5 fixed IVs, R^2 = .1, sample size of 95
p_lm.R2(n=95, R2=.1, k=5)

# random model
p_lm.R2(n=95, R2=.1, k=5, fixed=FALSE)

# return analysis model
p_lm.R2(n=95, R2=.1, k=5, return_analysis=TRUE)

}
\seealso{
\code{\link{p_glm}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
