% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_level_plot.R
\name{spread_level_plot}
\alias{spread_level_plot}
\title{spread_level_plot}
\usage{
spread_level_plot(
  df,
  meas_var,
  factor_var,
  plot_line_fit = TRUE,
  plot_log10 = TRUE,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = "Median",
  y_title = "Spread",
  x_limits = NULL,
  x_major_breaks = waiver(),
  y_limits = NULL,
  y_major_breaks = waiver(),
  label_pts = TRUE
)
}
\arguments{
\item{df}{The required target data frame with a measure variable and a factor variable
with multiple levels.}

\item{meas_var}{A required string that names the measure variable from 'df'.}

\item{factor_var}{A required string that names the factor variable from 'df'.}

\item{plot_line_fit}{A logical which if \code{TRUE} plots a line fit between median and spread values.}

\item{plot_log10}{A logical which if \code{TRUE} will plot log10 values of median versus spread
instead of raw values.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} then the y axis title does not appear.}

\item{x_limits}{A numeric 2 element vector that sets the minimum
and maximum for the x axis.}

\item{x_major_breaks}{A numeric vector or function that defines
the exact major tic locations along the x axis.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and maximum for the y axis.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{label_pts}{A logical which if \code{TRUE} will label the plot points.}
}
\value{
A list object with a data.table and ggplot2 scatter plot.
}
\description{
Function produces a scatter plot of median versus spread across a variable's
  factor levels.

  The spread is defined as the difference between the 75th and 25th quartiles.
 Function returns a named list with a data.table of each level's median, quartile values,
  and a ggplot2 scatter plot with medians along the x axis and spreads along the y axis.
}
\examples{
library(here)
library(data.table)
library(ggplot2)
library(RplotterPkg)

spread_level_lst <- RplotterPkg::spread_level_plot(
  df = RplotterPkg::homeruns_2000,
  meas_var = "HOMERUNS",
  factor_var = "YEARS",
  x_title = "Log Median",
  y_title = "Log Spread"
)
spread_level_lst$scatter_plot

}
