% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_acg.R
\name{acg}
\alias{acg}
\alias{dacg}
\alias{racg}
\alias{mle.acg}
\title{Angular Central Gaussian Distribution}
\usage{
dacg(datalist, A)

racg(n, A)

mle.acg(datalist, ...)
}
\arguments{
\item{datalist}{a list of length-\eqn{p} unit-norm vectors.}

\item{A}{a \eqn{(p\times p)} symmetric positive-definite matrix.}

\item{n}{the number of samples to be generated.}

\item{...}{extra parameters for computations, including\describe{
\item{maxiter}{maximum number of iterations to be run (default:50).}
\item{eps}{tolerance level for stopping criterion (default: 1e-5).}
}}
}
\value{
\code{dacg} gives a vector of evaluated densities given samples. \code{racg} generates 
unit-norm vectors in \eqn{\mathbf{R}^p} wrapped in a list. \code{mle.acg} estimates 
the SPD matrix \eqn{A}.
}
\description{
For a hypersphere \eqn{\mathcal{S}^{p-1}} in \eqn{\mathbf{R}^p}, Angular 
Central Gaussian (ACG) distribution \eqn{ACG_p (A)} is defined via a density
\deqn{f(x\vert A) = |A|^{-1/2} (x^\top A^{-1} x)^{-p/2}} 
with respect to the uniform measure on \eqn{\mathcal{S}^{p-1}} and \eqn{A} is 
a symmetric positive-definite matrix. Since \eqn{f(x\vert A) = f(-x\vert A)}, 
it can also be used as an axial distribution on real projective space, which is
unit sphere modulo \eqn{\lbrace{+1,-1\rbrace}}. One constraint we follow is that 
\eqn{f(x\vert A) = f(x\vert cA)} for \eqn{c > 0} in that we use a normalized 
version for numerical stability by restricting \eqn{tr(A)=p}.
}
\examples{
# -------------------------------------------------------------------
#          Example with Angular Central Gaussian Distribution
#
# Given a fixed A, generate samples and estimate A via ML.
# -------------------------------------------------------------------
## GENERATE AND MLE in R^5
#  Generate data
Atrue = diag(5)          # true SPD matrix
sam1  = racg(50,  Atrue) # random samples
sam2  = racg(100, Atrue)

#  MLE
Amle1 = mle.acg(sam1)
Amle2 = mle.acg(sam2)

#  Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(Atrue[,5:1], axes=FALSE, main="true SPD")
image(Amle1[,5:1], axes=FALSE, main="MLE with n=50")
image(Amle2[,5:1], axes=FALSE, main="MLE with n=100")
par(opar)

}
\references{
\insertRef{tyler_statistical_1987}{Riemann}

\insertRef{mardia_directional_1999}{Riemann}
}
\concept{distribution}
