% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppTskit.R
\name{tc_load}
\alias{tc_load}
\alias{tc_read}
\title{Load a table collection from a file}
\usage{
tc_load(file, skip_tables = FALSE, skip_reference_sequence = FALSE)

tc_read(file, skip_tables = FALSE, skip_reference_sequence = FALSE)
}
\arguments{
\item{file}{a string specifying the full path to a tree sequence file.}

\item{skip_tables}{logical; if \code{TRUE}, load only non-table information.}

\item{skip_reference_sequence}{logical; if \code{TRUE}, skip loading
reference sequence information.}
}
\value{
A \code{\link{TableCollection}} object.
}
\description{
Load a table collection from a file
}
\details{
See the corresponding Python function at
  \url{https://github.com/tskit-dev/tskit/blob/dc394d72d121c99c6dcad88f7a4873880924dd72/python/tskit/tables.py#L3463}.
}
\section{Functions}{
\itemize{
\item \code{tc_read()}: Alias for \code{tc_load()}

}}
\examples{
ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- tc_load(ts_file)
is(tc)
tc
}
\seealso{
\code{\link[=TableCollection]{TableCollection$new}}
}
