% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/random_gaussian_nb.R
\name{print.random_gaussian_nb}
\alias{print.random_gaussian_nb}
\alias{summary.random_gaussian_nb}
\alias{str.random_gaussian_nb}
\alias{nobs.random_gaussian_nb}
\alias{fitted.random_gaussian_nb}
\alias{plot.random_gaussian_nb}
\alias{random_gaussian_nb}
\title{Train a Random Naive Bayes Model via Bootstrap + Random Subspace (Mixed Types)}
\usage{
\method{print}{random_gaussian_nb}(x, ...)

\method{summary}{random_gaussian_nb}(object, ...)

\method{str}{random_gaussian_nb}(object, ...)

\method{nobs}{random_gaussian_nb}(object, ...)

\method{fitted}{random_gaussian_nb}(object, ...)

\method{plot}{random_gaussian_nb}(
  x,
  which = c("feature_frequency", "prior_variability", "prob_entropy"),
  newdata = NULL,
  top = 20,
  ...
)

random_gaussian_nb(
  data,
  response,
  n_iter = 100,
  feature_fraction = 0.5,
  cores = 1,
  laplace = 1
)
}
\arguments{
\item{x}{A \code{random_gaussian_nb} object.}

\item{...}{Passed to the underlying plotting function (e.g., \code{\link[graphics:barplot]{barplot()}},
\code{\link[graphics:boxplot]{boxplot()}}, \code{\link[graphics:hist]{hist()}}).}

\item{object}{A \code{random_gaussian_nb} object.}

\item{which}{Diagnostic to plot: \code{"feature_frequency"}, \code{"prior_variability"}, or \code{"prob_entropy"}.}

\item{newdata}{Optional new data for \code{"prob_entropy"}. If \code{NULL}, uses the training data.}

\item{top}{Number of top features to show for \code{"feature_frequency"}.}

\item{data}{A data.frame containing predictors and the response.}

\item{response}{Name of the response column (string).}

\item{n_iter}{Positive integer; number of bootstrap iterations.}

\item{feature_fraction}{Numeric in (0,1]; fraction of features sampled each iteration.}

\item{cores}{Positive integer; number of parallel workers.}

\item{laplace}{Numeric >= 0; Laplace smoothing parameter for categorical features.}
}
\value{
An object of class \code{"random_gaussian_nb"} containing the fitted
bootstrap ensemble and training metadata.
}
\description{
Fits an ensemble Naive Bayes classifier by repeating (i) stratified bootstrap
resampling of rows and (ii) random feature-subset selection, then aggregates
predictions by posterior averaging.
}
\details{
Numeric predictors use Gaussian likelihoods; categorical predictors
(factor/character/logical) use multinomial likelihoods with Laplace smoothing.

Numeric predictors use Gaussian likelihoods; categorical predictors
(factor/character/logical) use multinomial likelihoods with Laplace smoothing.

The following S3 methods are available for this class:
\describe{
\item{\code{print(x, ...)}}{Returns \code{x} invisibly (called for side effects).}
\item{\code{summary(object, ...)}}{Returns \code{object} invisibly (prints a summary).}
\item{\code{str(object, ...)}}{Returns \code{object} invisibly (prints a compact structure).}
\item{\code{nobs(object, ...)}}{Returns an integer: number of training observations.}
\item{\code{fitted(object, ...)}}{Returns a factor of fitted class labels for the training data.}
\item{\code{plot(x, ...)}}{Returns \code{x} invisibly (called for its side effects).}
}
}
