% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-sigPath.R
\name{getCommonPathways}
\alias{getCommonPathways}
\title{Retrieve common significant pathways from multiple pathway analysis results}
\usage{
getCommonPathways(PAResults, pThreshold = 0.05, useFDR = TRUE)
}
\arguments{
\item{PAResults}{A list of data frames with the results of pathway analysis.}

\item{pThreshold}{The p-value threshold to determine if a pathway is enriched or significant.}

\item{useFDR}{Use the FDR adjusted p-value instead of the nominal p-value.}
}
\value{
A data frame contains pathway ID and pathway names.
}
\description{
Query a list of common significant pathways from multiple pathway analysis results.
}
\examples{
\donttest{

library(RCPA)


affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")

PAResults <- list(
    "Affymetrix - GSE5281" = affyFgseaResult,
    "Agilent - GSE61196" = agilFgseaResult,
    "RNASeq - GSE153873" = RNASeqFgseaResult
)

commonPathways <- RCPA::getCommonPathways(PAResults)

print(head(commonPathways))

}

}
