% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_api_key.R
\name{check_api_key}
\alias{check_api_key}
\title{Check Purple Air API Key}
\usage{
check_api_key(purple_air_api_key = Sys.getenv("PURPLE_AIR_API_KEY"))
}
\arguments{
\item{purple_air_api_key}{A character that is your PurpleAir API \code{READ} key}
}
\value{
If the key is valid, a message is emitted and the input is invisibly returned;
invalid keys will throw an R error which utilizes information from the underlying http error
to inform the user.
}
\description{
Use the PurpleAir API to validate your Purple Air API Key.
Find more details on this function at https://api.purpleair.com/#api-keys-check-api-key.
Storing your key in the environment variable \code{PURPLE_AIR_API_KEY} is safer than storing it
in source code and is used by default in each PurpleAir function.
}
\examples{
\dontrun{
check_api_key()
try(check_api_key("foofy"))
}
}
\seealso{
get_organization_data
}
