% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAplot.R
\name{BAplot}
\alias{BAplot}
\title{Plot basal areas on a map of quadrats}
\usage{
BAplot(
  formula,
  data,
  taxon = "taxon",
  circumference = TRUE,
  quadrat.size,
  dead = "dead",
  rm.dead = FALSE,
  origin = c(0, 0),
  col = "grey40",
  alpha = 1,
  cex.radius = 1,
  ind.coord = FALSE,
  legend = TRUE,
  long = FALSE
)
}
\arguments{
\item{formula}{A model formula indicating the trunk measure (circumference [default]
or diameter) in centimeters and the xy coordinates of each quadrat the tree belongs
(\code{ind.coord = FALSE}) or, the actual tree coordinates (\code{ind.coord = TRUE}).
Example: \code{measure ~ x + y}. See Details.}

\item{data}{A data frame containing the community sample data. See Details.}

\item{taxon}{Name of the column representing the sampled taxa. Default is \code{"taxon"}.}

\item{circumference}{Logical. If \code{TRUE} (the default), the function assumes that the
circumference at breast height was measured.}

\item{quadrat.size}{A vector indicating the side lengths (in meters) of the x and y quadrat
sides (e.g., \code{c(x, y)}). It can be given as a single value if the quadrat is a square.}

\item{dead}{String used to identify the dead individuals. Default is \code{"dead"}.}

\item{rm.dead}{Logical. If \code{FALSE} (the default) basal areas of dead individuals are plotted.}

\item{origin}{A numeric vector indicating the map origin coordinates. Default is \code{c(0, 0)}.}

\item{col}{Circle color of represented basal areas. This argument has value only if
\code{legend = FALSE}. Default is \code{"grey40"}.}

\item{alpha}{Value of transparency factor: zero (100\% transparent) -- 1 (no transparency).
Default is 1.}

\item{cex.radius}{A numerical value giving the amount by which the tree radius should be
magnified relative to the actual measure. Default is 1.}

\item{ind.coord}{Logical indicating whether the individual coordinates are given. If
\code{FALSE} (the default) the tree coordinates inside the quadrats are randomly defined.
If \code{TRUE}, the actual tree coordinates are plotted.}

\item{legend}{Logical. If \code{TRUE} (default), the taxon is used as the color legend;
otherwise, circle color will be defined by the argument \code{col}.}

\item{long}{Logical. If \code{FALSE} (default) the function does not return the result data frame,
which contains xy coordinates, radius and taxon name of each sampled tree.}
}
\value{
A plot representing the quadrat map and tree basal areas. If \code{long = TRUE}, the
function returns a data frame containing taxon name, xy coordinates and radius of each sampled tree.
}
\description{
Plot basal areas of trees on a map of quadrats. If individual tree coordinates
are not known, the coordinates inside the quadrats are randomly defined according
to the uniform distribution.
}
\details{
\code{BAplot} uses the function \code{circleRepelLayout()} from the \pkg{packcircles} package
to rearrange circle coordinates to avoid overlapping. The minimum distance allowed among trees
is 1 meter. The packages \pkg{ggforce} and \pkg{ggplot2} are used to draw the map.

The data frame passed to the \code{data} argument must include two columns indicating x and y
coordinates of each quadrat that the tree belongs or the actual tree coordinates. If actual
coordinates are supplied, the \code{ind.coord} argument must be set \code{TRUE}.

Circumference/diameter measures accept the traditional notation for multiple trunks, e.g.,
\code{"17.1+8+5.7+6.8"}. The plus sign is the separator for each trunk measure. Decimal
separator can be point or comma and spaces after or before \code{"+"} are ignored by the function.
}
\examples{
# Using plot coordinates (random coordinates for individuals)
data1 <- quadrat2_plot.df
BAplot(formula = CBH ~ x + y, data = data1, taxon = "Species",
       circumference = TRUE, quadrat.size = 5, dead = "Morta",
       rm.dead = FALSE, alpha = 0.4, cex.radius = 2,
       legend = TRUE, long = FALSE, ind.coord = FALSE)

# Using actual coordinates
data2 <- quadrat2_tree.df
BAplot(formula = CBH ~ x + y, data = data2, taxon = "Species",
       circumference = TRUE, quadrat.size = 5, dead = "Morta",
       rm.dead = FALSE, alpha = 0.4, cex.radius = 2,
       legend = TRUE, long = FALSE, ind.coord = TRUE)

# Rectangular plots and plot coordinates
data3 <- quadrat3_rect.df
BAplot(formula = DBH ~ x + y, data = data3, taxon = "Species",
       circumference = FALSE, quadrat.size = c(20, 10),
       dead = "Morta", rm.dead = FALSE, col = "blue",
       alpha = 0.4, cex.radius = 2, legend = FALSE,
       long = FALSE, ind.coord = FALSE)

}
\references{
Collins, C. R., and Stephenson, K. (2003). A circle packing algorithm.
  \emph{Computational Geometry}, 25(3), 233--256. \doi{10.1016/S0925-7721(02)00099-8}

Wang, W., Wang, H., Dai, G., and Wang, H. (2006). Visualization of large hierarchical data by circle packing.
  \emph{Proceedings of the SIGCHI Conference on Human Factors in Computing Systems}, 517--520.
  \doi{10.1145/1124772.1124851}
}
\author{
Rodrigo A. S. Pereira (\email{raspereira@usp.br})
}
