% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_Pathway_Visualization.R
\name{olink_pathway_visualization}
\alias{olink_pathway_visualization}
\title{Creates bargraph of top/selected enrichment terms from GSEA or ORA results from olink_pathway_enrichment()}
\usage{
olink_pathway_visualization(
  enrich_results,
  method = "GSEA",
  keyword = NULL,
  number_of_terms = 20
)
}
\arguments{
\item{enrich_results}{data frame of enrichment results from olink_pathway_enrichment()}

\item{method}{method used in olink_pathway_enrichment ("GSEA" (default) or "ORA")}

\item{keyword}{(optional) keyword to filter enrichment results on, if not specified, displays top terms}

\item{number_of_terms}{number of terms to display, default is 20}
}
\value{
A bargraph as a ggplot object
}
\description{
Pathways are ordered by increasing p-value (unadjusted)
}
\examples{
\donttest{
library(dplyr)
# Run olink_ttest or other stats test (see documentaiton )
npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))
ttest_results <- olink_ttest(df=npx_df,
                             variable = 'Treatment',
                             alternative = 'two.sided')

try({ # This expression might fail if dependencies are not installed
# Run olink_pathway_enrichment (see documentation)
gsea_results <- olink_pathway_enrichment(data = npx_data1, test_results = ttest_results)
ora_results <- olink_pathway_enrichment(data = npx_data1,
                                       test_results = ttest_results, method = "ORA")
olink_pathway_visualization(enrich_results = gsea_results)
olink_pathway_visualization(enrich_results = gsea_results, keyword = "immune")
olink_pathway_visualization(enrich_results = ora_results, method = "ORA", number_of_terms = 15)
})

}

}
\seealso{
\itemize{
\item{\code{\link[OlinkAnalyze:olink_pathway_enrichment]{olink_pathway_enrichment}} for generating enrichment results}
\item{\code{\link[OlinkAnalyze:olink_pathway_heatmap]{olink_pathway_heatmap}} for generating a heat map of results}
}
}
