% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{OASIS_cross_tbl_df}
\alias{OASIS_cross_tbl_df}
\title{Cross-sectional Brain MRI Data Across Adult Lifespan}
\format{
A tibble with 436 observations and 12 variables:
\describe{
  \item{ID}{Subject identifier (character)}
  \item{M/F}{Sex of the participant (character)}
  \item{Hand}{Handedness of the participant (character)}
  \item{Age}{Age in years (numeric)}
  \item{Educ}{Years of education (numeric)}
  \item{SES}{Socioeconomic status score (numeric)}
  \item{MMSE}{Mini-Mental State Examination score (numeric)}
  \item{CDR}{Clinical Dementia Rating score (numeric)}
  \item{eTIV}{Estimated total intracranial volume (numeric)}
  \item{nWBV}{Normalized whole-brain volume (numeric)}
  \item{ASF}{Atlas scaling factor (numeric)}
  \item{Delay}{Inter-scan interval in days (character)}
}
}
\source{
Data taken from Kaggle: \url{https://www.kaggle.com/datasets/jboysen/mri-and-alzheimers}
}
\usage{
data(OASIS_cross_tbl_df)
}
\description{
This dataset, OASIS_cross_tbl_df, is a tibble containing a cross-sectional collection of MRI data
from 436 individuals aged 18 to 96, obtained as part of the Open Access Series of Imaging Studies (OASIS).
For each subject, 3 or 4 T1-weighted MRI scans acquired during a single scanning session are included.
All participants are right-handed and include both men and women. Among the subjects over the age of 60,
100 have been clinically diagnosed with very mild to moderate Alzheimer’s disease (AD).
}
\details{
The dataset name has been kept as OASIS_cross_tbl_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix tbl_df indicates that the dataset is a tibble (a modern data frame).
The original content has not been modified in any way. Variable names and values are provided exactly
as they appear in the source.
}
