% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pheno.time.R
\name{get.pheno.time}
\alias{get.pheno.time}
\title{Derive phenotyping time point}
\usage{
get.pheno.time(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  use.id = TRUE,
  use.all.copy = TRUE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: TRUE)}

\item{use.all.copy}{Set to TRUE to extract phenotyping}
}
\value{
Timepoint (of phenotyping) of in gen/database/cohorts selected individuals
}
\description{
Function to derive timepoint of phenotyping for each individual
}
\examples{
data(ex_pop)
get.pheno.time(ex_pop, gen=2)
}
