% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.nindi.R
\name{get.nindi}
\alias{get.nindi}
\title{Number of individuals}
\usage{
get.nindi(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  extended = FALSE,
  count.copy = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{extended}{Set to TRUE to export information on number of phenotyped, genotyped, and both pheno&genotyped individuals}

\item{count.copy}{Set to TRUE to double count individuals if multiple copies of an individual are included in gen/database/cohorts}
}
\value{
Numeric value
}
\description{
Function to calculate the number of individuals in the population list
}
\examples{
data(ex_pop)
get.nindi(ex_pop, gen = 1)
}
