% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.calculate.R
\name{cal_sim}
\alias{cal_sim}
\title{Calculate similarity for one t(otutab)}
\usage{
cal_sim(totu, totu2 = NULL, method = "bray")
}
\arguments{
\item{totu}{t(otutab), row are samples, column are features.}

\item{totu2}{t(otutab) or NULL, row are samples, column are features.}

\item{method}{Dissimilarity index, see \code{\link[vegan]{vegdist}}.}
}
\value{
similarity = 1-distance
}
\description{
Calculate similarity for one t(otutab)
}
\examples{
if (requireNamespace("vegan")) {
  data("otutab", package = "pcutils")
  t(otutab) -> totu
  cal_sim(totu) -> sim_corr
}
}
\seealso{
\code{\link[vegan]{vegdist}}

Other calculate: 
\code{\link{c_net_calculate}()},
\code{\link{fast_cor}()},
\code{\link{p.adjust.table}()},
\code{\link{read_corr}()}
}
\concept{calculate}
