\name{Log_Likelihood_function_E_ReMI}
\alias{Log_Likelihood_function_E_ReMI}
\title{
Log-Likelihood Calculation for E-ReMI Clustering
}
\description{
Computes the log-likelihood of the observed data in the E-ReMI clustering framework.
}
\usage{
Log_Likelihood_function_E_ReMI(DC, I, J, initM, initOmega_hat)
}
\arguments{
  \item{DC}{
A numeric data matrix of dimension \code{I x J} representing the input data with double centering. 
}
  \item{I}{
An integer indicating the number of rows (units) in the data matrix \code{DC}.
}
  \item{J}{
An integer indicating the number of columns (conditions or variables) in the data matrix \code{DC}.
}
  \item{initM}{
A numeric matrix of the same dimension as \code{DC} representing the reconstructed matrix based on current estimates of cluster assignments and latent interaction parameters.
It is computed via random row partition matrix (R), random column partition matrix (C) and bi-cluster interaction matrix (G) and updated after each iteration.  
}
  \item{initOmega_hat}{
A numeric vector of length equal to the number of row clusters, representing the estimated mixing proportions (probabilities) of row clusters.
}
}
\details{
This function is used internally in the E-ReMI algorithm to monitor model fit by calculating the log-likelihood of the observed data under the current clustering configuration and model estimates. The error matrix is computed by subtracting the reconstructed matrix \code{initM} from the observed data \code{DC}, and the log-likelihood is derived from the Gaussian likelihood function with known variance.
}
\value{
Returns a numeric scalar:
  \item{LL}{The log-likelihood value of the current E-ReMI model configuration.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function is intended for internal use in model monitoring and convergence checking during E-ReMI algorithm execution.
}
\seealso{
\code{\link{E_ReMI}}, \code{\link{Update_row_clusters_E_ReMI}}, \code{\link[pracma]{pinv}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2
DC <- matrix(rnorm(I*J), I, J)
R  <- diag(1, I, P)
C  <- diag(1, J, Q)
R_inv <- pracma::pinv(t(R) \%*\% R)
C_inv <- pracma::pinv(t(C) \%*\% C)
G <- R_inv \%*\% t(R) \%*\% DC \%*\% C \%*\% C_inv
initM <- R \%*\% G \%*\% t(C)
initOmega_hat <- c(0.5, rep((1-0.5)/P, P))
result <- Log_Likelihood_function_E_ReMI(DC, I, J, initM, initOmega_hat)
result
}
\keyword{E-ReMI}
\keyword{likelihood}
\keyword{unequally sized row clusters}
