% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_MSU.R
\name{theme_MSU}
\alias{theme_MSU}
\title{Michigan State University (MSU) Theme}
\usage{
theme_MSU(
  base_size = 11,
  base_family = "Metropolis",
  header_family = NULL,
  base_line_size = base_size/22,
  base_rect_size = base_size/22,
  rel_small = 12/14,
  rel_tiny = 11/14,
  rel_large = 16/14,
  ink = "black",
  paper = "white",
  accent = "#3366FF"
)
}
\arguments{
\item{base_size}{Base font size for text elements. Default 12.}

\item{base_family}{Font used for all text elements. Default "Metropolis".}

\item{header_family}{Font family for titles and headers. The default, NULL, uses theme inheritance to set the font. This setting affects axis titles, legend titles, the plot title and tag text.}

\item{base_line_size}{Base line size is \code{base_size/22}}

\item{base_rect_size}{Base rectangle size is \code{base_size/22}}

\item{rel_small}{Relative size of small text (e.g., axis tick labels)}

\item{rel_tiny}{Relative size of tiny text (e.g., caption)}

\item{rel_large}{Relative size of large text (e.g., title)}

\item{ink}{Text colour. Default "black".}

\item{paper}{Background colour. Default "white".}

\item{accent}{Accent colour. Default bright blue, "#3366FF"}
}
\value{
A ggplot2 theme
}
\description{
Custom ggplot2 theme
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, color = wt)) +
  geom_point() +
  theme_MSU()

}
