% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QrhoIC.R
\name{QrhoIC}
\alias{QrhoIC}
\title{QrhoIC.R}
\usage{
QrhoIC(
  rhoVec,
  icskatOut,
  liu = TRUE,
  bootstrapOut = NULL,
  alwaysCentral = FALSE
)
}
\arguments{
\item{rhoVec}{Numeric vector of the rho values to use in SKATO.}

\item{icskatOut}{The output list returned from  a call to ICSKAT().}

\item{liu}{Boolean for whether to use Liu (TRUE) or Davies (FALSE) method in calculating p-values for each Qrho.
Default is Liu, following SKAT package. If wanting to use bootstrap moments for Qrho, need to use Liu method.}

\item{bootstrapOut}{The output (a list) from a call the ICSKATO_bootstrap() function, holding moments for Qrho.}

\item{alwaysCentral}{A boolean, if TRUE, follow SKAT package practice of always setting delta=0 in chi-square moment matching.}
}
\value{
Data frame holding the SKAT pvalue + test statistic for each fixed rho, the matched noncentrality + degree of freedom parameters
for each fixed rho (using both bootstrap and analytic calculation), and the mean and variance of each Qrho using both
bootstrap and analytic calculation.
}
\description{
Calculate the test statistic, distribution, and p-value for each value of Krho in SKATO.
}
