% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{scale_node_positions}
\alias{scale_node_positions}
\title{Scale node positions in an \code{igraph} object}
\usage{
scale_node_positions(layout, scale_factor = 1.2)
}
\arguments{
\item{layout}{A 2-column matrix representing the position data, where the columns are the x- and y-coordinates of each node, respectively.}

\item{scale_factor}{A numeric value indicating the factor by which to scale the node positions. The default is \code{scale_factor = 1.2}.}
}
\value{
A matrix of updated node positions.
}
\description{
This function scales the positions of nodes in a graph relative to their centroid; compatible with expansions and contractions.
}
\details{
This function expands or contracts the graph around a centroid, facilitating visualization. Factors greater than 1 expand the network around the centroid while those less than 1 contract it around the centroid.
\code{scale_factor = 1} is no change. Note that unscaled plot commands like \code{plot(g, layout = layout_expanded)} make the change difficult to see, so scaled plots are recommended for comparison.
}
\examples{
  set.seed(10)
  library(igraph)

  # Generating graph and setting initial layout
  g <- sample_gnp(100, 0.05)
  layout <- layout_with_fr(g)

  # Plotting original graph, maintaining fixed scale so expansion is clear
  plot(layout, main="Original Graph", xlab="", ylab="", xlim=c(-20, 15), ylim=c(-20, 15))

  # Expanding node positions
  layout_expanded <- scale_node_positions(layout, 2)

  # Plotting expanded graph, maintaining fixed scale so expansion is clear
  plot(layout_expanded, main="Expanded Graph", xlab="", ylab="", xlim=c(-20, 15), ylim=c(-20, 15))

  # Contract node positions
  layout_cont <- scale_node_positions(layout, 0.8)

  # Plotting contracted graph, maintaining fixed scale so transformation is clear
  plot(layout_cont, main="Contracted Graph", xlab="", ylab="", xlim=c(-20, 15), ylim=c(-20, 15))


  # Note that igraph plots like below make it difficult to see the transformation,
  # because they are autoscaled.
  # plot(g, layout = layout_expanded)
  # The change is easy to see in scaled plots, as shown.

}
