% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_covariates.R
\name{cov_add}
\alias{cov_add}
\title{Add Covariates to All Combinations}
\usage{
cov_add(covariates, name, add = FALSE)
}
\arguments{
\item{covariates}{A character vector or a list of character vectors, where each vector
represents a set of covariates (e.g., from \code{\link{cov_multi}}).}

\item{name}{A character vector of covariate names to be added to each set.}

\item{add}{Boolean that indicates if the original combinations in the \code{covariates}
argument must be kept. Defaults to FALSE.}
}
\value{
A list of character vectors, with each vector containing the original covariates
plus the additional ones specified in the \code{name} argument.
}
\description{
This function appends one or more covariate names to all elements (i.e., covariate sets)
in a list of character vectors. This is useful when a covariate (like a confounder or
control variable) needs to be included in every model. It also works with a single
character vector input.  The resulting list
can be input into the \code{covariates} argument in \code{\link{write_inla_formulas}}.
}
\examples{
# Multiple combinations
cov_sets <- list(
  c("tmin", "pdsi"),
  c("tmin.l1", "pdsi"),
  c("tmin.l2", "pdsi")
)
cov_add(cov_sets, name = "urban")

}
