% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_metrics.R
\name{quantile_exceedance_proba_error}
\alias{quantile_exceedance_proba_error}
\title{Quantile exceedance probability prediction calibration error}
\usage{
quantile_exceedance_proba_error(
  Probs,
  prob_level = NULL,
  return_years = NULL,
  type_probs = c("cdf", "exceedance"),
  na.rm = FALSE
)
}
\arguments{
\item{Probs}{Predicted probabilities to exceed or be smaller than a fixed quantile.}

\item{prob_level}{Probability level of the quantile.}

\item{return_years}{The probability level can be given in term or return years instead.
Only used if \code{prob_level} is not given.}

\item{type_probs}{Whether the predictions are the \code{"cdf"} (default) or \code{"exceedance"} probabilities.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}
}
\value{
The calibration metric for the predicted probabilities.
}
\description{
Quantile exceedance probability prediction calibration error
}
\examples{
quantile_exceedance_proba_error(c(0.1, 0.3, 0.2), prob_level=0.8)
}
