% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_stat}
\alias{plot_stat}
\title{Plot Statistics on Data}
\usage{
plot_stat(
  input,
  post_predict = NULL,
  prior_predict = NULL,
  stat_fun,
  stat_name = NULL,
  subject = NULL,
  factors = NULL,
  n_cores = 1,
  n_post = 50,
  quants = c(0.025, 0.5, 0.975),
  functions = NULL,
  layout = NA,
  to_plot = c("data", "posterior", "prior")[1:2],
  use_lim = c("data", "posterior", "prior")[1:2],
  legendpos = c("topleft", "top"),
  posterior_args = list(),
  prior_args = list(),
  ...
)
}
\arguments{
\item{input}{Either an \code{emc} object or a data frame, or a \emph{list} of such objects.}

\item{post_predict}{Optional posterior predictive data (matching columns) or \emph{list} thereof.}

\item{prior_predict}{Optional prior predictive data (matching columns) or \emph{list} thereof.}

\item{stat_fun}{A function that can be applied to the data and returns a single value or a vector of values.}

\item{stat_name}{The name of the calculated quantity}

\item{subject}{Subset the data to a single subject (by index or name).}

\item{factors}{Character vector of factor names to aggregate over;
defaults to plotting full data set ungrouped by factors if \code{NULL}.}

\item{n_cores}{Number of CPU cores to use if generating predictives from an \code{emc} object.}

\item{n_post}{Number of posterior draws to simulate if needed for predictives.}

\item{quants}{Numeric vector of credible interval bounds (e.g. \code{c(0.025, 0.975)}).}

\item{functions}{A function (or list of functions) that create new columns in the datasets or predictives}

\item{layout}{Numeric vector used in \code{par(mfrow=...)}; use \code{NA} for auto-layout.}

\item{to_plot}{Character vector: any of \code{"data"}, \code{"posterior"}, \code{"prior"}.}

\item{use_lim}{Character vector controlling which source(s) define \code{xlim}.}

\item{legendpos}{Character vector controlling the positions of the legends}

\item{posterior_args}{Optional list of graphical parameters for posterior lines/ribbons.}

\item{prior_args}{Optional list of graphical parameters for prior lines/ribbons.}

\item{...}{Other graphical parameters for the real data lines.}
}
\value{
an invisible data frame with the stat applied to the real data, posterior predictives and/or prior predictives
}
\description{
Plots panels that contain a set of densities for each level of the specified \code{factor}
The densities represent the predicted data across the posterior, the vertical lines represent the real data.
}
\examples{
# For example plot the observed and predicted response accuracy
# Can also apply more sophisticated statistics
drt <- function(data) diff(tapply(data$rt,data[,c("E")],mean))
plot_stat(samples_LNR, stat_fun = drt, n_post = 10, stat_name = "RT diff Speed - A/N")

}
