% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R, R/s3_funcs.R
\name{credint.emc.prior}
\alias{credint.emc.prior}
\alias{credint.emc}
\alias{credint}
\title{Posterior Quantiles}
\usage{
\method{credint}{emc.prior}(
  x,
  selection = "mu",
  probs = c(0.025, 0.5, 0.975),
  digits = 3,
  N = 1000,
  covariates = NULL,
  ...
)

\method{credint}{emc}(x, selection = "mu", probs = c(0.025, 0.5, 0.975), digits = 3, ...)

credint(x, ...)
}
\arguments{
\item{x}{An emc or emc.prior object}

\item{selection}{A Character vector. Indicates which parameter types to check (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{probs}{A vector. Indicates which quantiles to return from the posterior.}

\item{digits}{Integer. How many digits to round the output to}

\item{N}{An integer. Number of samples to use for the quantile calculation (only for prior.emc objects)}

\item{covariates}{A list of covariates to use for the quantile calculation (only for prior.emc objects)}

\item{...}{Optional additional arguments that can be passed to \code{get_pars}}
}
\value{
A list of posterior quantiles for each parameter group in the selected parameter type.
}
\description{
Returns the quantiles of the selected parameter type.
Full range of possible samples manipulations described in \code{get_pars}.
}
\examples{
credint(samples_LNR)
}
