% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{add_las_attributes}
\alias{add_las_attributes}
\title{Add all las_attributes from las@data to the header of a las element}
\usage{
add_las_attributes(las)
}
\arguments{
\item{las}{an element of lidR::LAS class}
}
\value{
the las file with updated header
}
\description{
The helper function adds all headings from las@data which are not part of
lidR:::LASATTRIBUTES to the las header using lidR::add_lasattribute. Only
attributes that are included in the header got saved when using
lidR::writeLAS, this is a convenient way to add them.
}
\examples{

file <- system.file("extdata", "beech.las", package="CspStandSegmentation")
las <- lidR::readTLSLAS(file)

las@data$noise <- runif(nrow(las@data))
las@data$noiseZ <- las@data$var1 * las@data$Z

las <- add_las_attributes(las)

}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
