% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortCount.R
\name{plotCohortCount}
\alias{plotCohortCount}
\title{Plot the result of summariseCohortCount.}
\usage{
plotCohortCount(
  result,
  x = NULL,
  facet = c("cdm_name"),
  colour = NULL,
  style = "default"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Variables to use in x axis.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Named list that specifies how to style the different parts of
the table generated. It can either be a pre-defined style ("default" or
"darwin" - the latter just for gt and flextable), NULL to get the table
default style, or custom. Keep in mind that styling code is different for
all table styles. To see the different styles see \code{visOmopResults::tableStyle()}.}
}
\value{
A ggplot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)
library(PatientProfiles)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCohortCharacteristics(numberIndividuals = 100)

counts <- cdm$cohort2 |>
  addSex() |>
  addAge(ageGroup = list(c(0, 29), c(30, 59), c(60, Inf))) |>
  summariseCohortCount(strata = list("age_group", "sex", c("age_group", "sex"))) |>
  filter(variable_name == "Number subjects")

counts |>
  plotCohortCount(
    x = "sex",
    facet = cohort_name ~ age_group,
    colour = "sex"
  )

}

}
