#2020-12-28
CP2label <- function(AWT,SLT,len){
  CP <- sort(c(AWT,SLT))
  labels<- rep(0,len)
  if(CP[1] %in% SLT){
    labels[1:SLT[1]] <- 1 #first change is sleep time, first phase is awake
    for(i in 1:(length(SLT)-1)){
      s1 <- c(SLT[i]:AWT[i]) #Sleep phase, state 1
      s2 <- c(AWT[i]:SLT[i+1]) #awake phase, state 2
      labels[s1] <- rep(0,length(s1))
      labels[s2] <- rep(1,length(s2))
    }
  } else {
    labels[1:AWT[1]] <- 0 #first change is awake time, first phase is sleep
    for(i in 1:(length(AWT)-1)){
      s1 <- c(AWT[i]:SLT[i]) #awake phase, state 1, state 1 doens't contain very high value
      s2 <- c((SLT[i]+1):(AWT[i+1]-1)) #sleep phase, state 2, state 2 contains low value
      labels[s1] <- rep(1,length(s1)) 
      labels[s2] <- rep(0,length(s2))
    }
  } #end of else
  if(CP[length(CP)] %in% SLT){
    labels[SLT[length(SLT)]:length(labels)] <- 0
    labels[CP[length(CP)-1]:SLT[length(SLT)]] <- 1
  } else {
    labels[AWT[length(AWT)]:length(labels)] <- 1
    labels[CP[length(CP)-1]:AWT[length(AWT)]] <- 0
  }
  return(labels)
}#end of function
