% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_dotplot}
\alias{plot_dotplot}
\title{A function to visualize dot plots for a gene.}
\usage{
plot_dotplot(sgcount, df_design, gene, ge_id = NULL, sg_id = NULL)
}
\arguments{
\item{sgcount}{The input matrix contains read counts of sgRNAs for each sample.}

\item{df_design}{The table contains a study design.}

\item{gene}{The gene to be shown.}

\item{ge_id}{A name of the column contains gene names.}

\item{sg_id}{A name of the column contains sgRNA IDs.}
}
\value{
A ggplot2 object contains dot plots of sgRNA read counts for a gene.
}
\description{
A function to visualize dot plots for a gene.
}
\examples{
library(CB2)
data(Evers_CRISPRn_RT112)
plot_dotplot(get_CPM(Evers_CRISPRn_RT112$count), Evers_CRISPRn_RT112$design, "RPS7")

}
