% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncated_normal.R
\name{bi.dist.truncated_normal}
\alias{bi.dist.truncated_normal}
\title{Truncated Normal Distribution}
\usage{
bi.dist.truncated_normal(
  loc = 0,
  scale = 1,
  low = py_none(),
  high = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{loc}{The location parameter of the normal distribution.}

\item{scale}{The scale parameter of the normal distribution.}

\item{low}{(float, jnp.ndarray, optional): The lower truncation point. If `None`, the distribution is only truncated on the right. Defaults to `None`.}

\item{high}{(float, jnp.ndarray, optional): The upper truncation point. If `None`, the distribution is only truncated on the left. Defaults to `None`.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector (e.g., `c(10)`) used to shape the distribution.
When `sample=False` (model building), this is used with `.expand(shape)` to set the
distribution's batch shape. When `sample=True` (direct sampling),
this is used as `sample_shape` to draw a raw JAX array of the
given shape.}

\item{event}{The number of batch dimensions to reinterpret as event
dimensions (used in model building).}

\item{create_obj}{Logical; If `TRUE`, returns the raw BI distribution
object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Truncated Normal distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Truncated Normal distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
A truncated normal distribution is derived from a normal (Gaussian)
random variable by restricting (truncating) its domain to an interval \deqn{[a, b]}
(which could be one-sided, e.g., (a) only or (b) only). It is defined by its location (`loc`), scale
(`scale`), lower bound  \deqn{a} (`low`), and upper bound \deqn{b} (`high`). In effect:
if \deqn{X \sim \mathcal N(\mu, \sigma^2)}, then the truncated version \deqn{Y = X | (a \le X \le b)}
has the same "shape" but only supports values in \deqn{[a,b]}. This is used when you know that values outside a range
are impossible or not observed (e.g., measurement limits, natural bounds).
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.truncated_normal(loc = 0, scale = 2, low = 0, high = 1.5, sample = TRUE)
}
}
