% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_variate_student_t.R
\name{bi.dist.multivariate_student_t}
\alias{bi.dist.multivariate_student_t}
\title{Multivariate Student's t Distribution}
\usage{
bi.dist.multivariate_student_t(
  df,
  loc = 0,
  scale_tril = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{df}{A numeric vector representing degrees of freedom, must be positive.}

\item{loc}{A numeric vector representing the location vector (mean) of the distribution.}

\item{scale_tril}{A numeric matrix defining the scale (lower triangular matrix).}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector. Optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector. When `sample=False` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Multivariate Student's t distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Multivariate Student's t distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The Multivariate Student's t distribution is a generalization of the Student's t
 distribution to multiple dimensions. It is a heavy-tailed distribution that is
often used to model data that is not normally distributed.
 The PDF of the multivariate Student's t-distribution for a random vector \deqn{ x \in R^d } is given by:
\deqn{
f(x) = \frac{\Gamma\left(\frac{\nu + d}{2}\right)}{\Gamma\left(\frac{\nu}{2}\right) \nu^{d/2} \pi^{d/2} | \Sigma|^{1/2}}
\left(1 + \frac{1}{\nu} (x - \mu)^T \Sigma^{-1} (x - \mu)\right)^{-(\nu + d)/2}
}
where:
* \deqn{ \Gamma(\cdot) } is the Gamma function.
* \deqn{ \mu } is the mean vector.
* \deqn{ \Sigma } is the scale (covariance) matrix.
* \deqn{ \nu } is the degrees of freedom.
* \deqn{ d } is the dimensionality of \deqn{ \mathbf{x}}.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.multivariate_student_t(
df = 2,
loc =  c(1.0, 0.0, -2.0),
scale_tril = chol(
matrix(c( 2.0,  0.7, -0.3, 0.7,  1.0,  0.5, -0.3,  0.5,  1.5),
nrow = 3, byrow = TRUE)),
sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#multivariatestudentt}
}
