% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/left_truncated_distribution.R
\name{bi.dist.left_truncated_distribution}
\alias{bi.dist.left_truncated_distribution}
\title{Samples from a left-truncated distribution.}
\usage{
bi.dist.left_truncated_distribution(
  base_dist,
  low = 0,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{base_dist}{The base distribution to truncate. Must be univariate and have real support.}

\item{low}{The lower truncation bound. Values less than this are excluded from the distribution.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean vector to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector. When \code{sample=FALSE} (model building),
this is used with `.expand(shape)` to set the distribution's batch shape.
When \code{sample=TRUE} (direct sampling), this is used as `sample_shape` to draw a raw
JAX array of the given shape.}

\item{event}{The number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}: A BI LeftTruncatedDistribution distribution object (for model building).

   - When \code{sample=TRUE}: A JAX array of samples drawn from the LeftTruncatedDistribution distribution (for direct sampling).

   - When \code{create_obj=TRUE}: The raw BI distribution object (for advanced use cases).
}
\description{
A left-truncated distribution is a probability distribution obtained by restricting the support of another distribution to values greater than a specified lower bound.
This is useful when dealing with data that is known to be greater than a certain value.
All the "mass" below (or equal to) (a) is excluded (not just unobserved, but removed from the sample/analysis).

\deqn{f(x) = \begin{cases}
          \frac{f(x)}{P(X > \text{low})} & \text{if } x > \text{low} \\
          0 & \text{otherwise}
          \end{cases}}
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.left_truncated_distribution(
base_dist = bi.dist.normal(loc = 1, scale = 10 ,  create_obj = TRUE),
sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#lefttruncateddistribution}
}
