% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.batss.R
\name{summary.batss}
\alias{summary.batss}
\title{Summary function for 'BATSS' outputs}
\usage{
\method{summary}{batss}(object, extended = NULL, ...)
}
\arguments{
\item{object}{An object of class 'batss' (i.e., output of the function \link{batss.glm}).}

\item{extended}{A logical indicating if a standard (extended = FALSE, default) or extended output (extended = TRUE) should be returned. Default to \code{NULL} in which case the input of the argument \code{extended} chosen when generating \code{object} with \code{\link[=batss.glm]{batss.glm()}} is used.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Object of class 'summary.batss'.

The function \link{summary.batss} returns an S3 list of class 'summary.batss' with available print functions. The list elements are
\itemize{
\item beta - A data frame providing information related to the beta parameter vector, such as parameter names and values, for example.
\item look - A data frame providing information related to looks, like sample size of a given interim (m) and cumulative sample size at a given interim (n), for example.
\item par - A list providing different information, like the used seeds (seed) and the groups (group), for example.
\item H1 - A list providing trial aggregated results under the alternative, like the probability of efficacy, futility, or both, per arm or globally (\code{object$H1$target}), the probability of stopping early for efficacy (\code{object$H1$efficacy}) and futility (\code{object$H1$futility}), the sample size expectation, standard deviation, and quantiles 0.1, 0.5 and 0.9, per group and overall (\code{object$H1$summary.sample.sizes}), the probabilities associated to each combination of efficacy and futility per group (scenario).
\item H0 - A list providing trial aggregated results under the global null hypothesis (same structure as H1).
\item call - The matched call.
\item type - The type of 'BATSS' analysis (only 'glm' is currently available).
}
}
\description{
Summary method function for objects of class 'batss'.
}
\seealso{
\code{\link[=batss.glm]{batss.glm()}}, the function generating S3 objects of class 'batss'.
}
