% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admm.tv.R
\name{admm.tv}
\alias{admm.tv}
\title{Total Variation Minimization}
\usage{
admm.tv(
  b,
  lambda = 1,
  xinit = NA,
  rho = 1,
  alpha = 1,
  abstol = 1e-04,
  reltol = 0.01,
  maxiter = 1000
)
}
\arguments{
\item{b}{a length-\eqn{m} response vector}

\item{lambda}{regularization parameter}

\item{xinit}{a length-\eqn{m} vector for initial value}

\item{rho}{an augmented Lagrangian parameter}

\item{alpha}{an overrelaxation parameter in \eqn{[1,2]}}

\item{abstol}{absolute tolerance stopping criterion}

\item{reltol}{relative tolerance stopping criterion}

\item{maxiter}{maximum number of iterations}
}
\value{
a named list containing \describe{
\item{x}{a length-\eqn{m} solution vector}
\item{history}{dataframe recording iteration numerics. See the section for more details.}
}
}
\description{
1-dimensional total variation minimization - also known as
signal denoising - is to solve the following
\deqn{\textrm{min}_x ~ \frac{1}{2}\|x-b\|_2^2 + \lambda \sum_i |x_{i+1}-x_i|}
for a given signal \eqn{b}.
The implementation is borrowed from Stephen Boyd's
\href{https://stanford.edu/~boyd/papers/admm/total_variation/total_variation.html}{MATLAB code}.
}
\section{Iteration History}{

When you run the algorithm, output returns not only the solution, but also the iteration history recording
following fields over iterates,
\describe{
\item{objval}{object (cost) function value}
\item{r_norm}{norm of primal residual}
\item{s_norm}{norm of dual residual}
\item{eps_pri}{feasibility tolerance for primal feasibility condition}
\item{eps_dual}{feasibility tolerance for dual feasibility condition}
}
In accordance with the paper, iteration stops when both \code{r_norm} and \code{s_norm} values
become smaller than \code{eps_pri} and \code{eps_dual}, respectively.
}

\examples{
## generate sample data
x1 = as.vector(sin(1:100)+0.1*rnorm(100))
x2 = as.vector(cos(1:100)+0.1*rnorm(100)+5)
x3 = as.vector(sin(1:100)+0.1*rnorm(100)+2.5)
xsignal = c(x1,x2,x3)

## run example
output  = admm.tv(xsignal)

## visualize
opar <- par(no.readonly=TRUE)
plot(1:300, xsignal, type="l", main="TV Regularization")
lines(1:300, output$x, col="red", lwd=2)
par(opar)

}
