## -----------------------------------------------------------------------------
as.Date(45812, origin = "1899-12-30")
#> "2025-03-30"

## -----------------------------------------------------------------------------
library(unexcel)

# Mixed vector: two serials + one real number
x <- c(45812, 12.5, 44730)

restore_day_month(x, origin_mode = "1900")
#> [1] 30.3 12.5 15.6

## -----------------------------------------------------------------------------
format(as.Date(45812, origin = "1899-12-30"), "%d/%m")
#> "30/03"

## -----------------------------------------------------------------------------
df <- data.frame(
  a = c(45812, 44730, 45900),
  b = c(1.2, 3.4, 5.6)
)

fix_serial_columns(df, origin_mode = "1900")
#>      a   b
#> 1 30.3 1.2
#> 2 15.6 3.4
#> 3 19.4 5.6

## -----------------------------------------------------------------------------
sessionInfo()

