## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)

## ----data---------------------------------------------------------------------
library(seinfitR)

data(glasshouse, package = "seinfitR")

## ----model_fit----------------------------------------------------------------
model <- seinfitR(
  p_i = "p_i", 
  y = "y", 
  data = glasshouse,
  start = list(m = 6, t = 6),
  control = seinfitR_control(maxiter = 20),
  z_fixed = TRUE
)

## ----summary------------------------------------------------------------------
summary(model)

## ----coefficients-------------------------------------------------------------
coef(model)

coef <- coef(model)

m <- coef[1]
t <- coef[2]
y_max <- coef[3]

cat("m:", m)
cat("t:", t)
cat("y_max", y_max)

## ----plot---------------------------------------------------------------------
plot(model, main = "Seinhorst Model Fit for Glasshouse Data")

