/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chocosolver.solver.Solution;
import org.restopt.RestoptProblem;
import org.restopt.exception.RestoptException;
import org.restopt.objectives.AbstractRestoptObjective;

public class MinRestoreObjective
extends AbstractRestoptObjective {
    public static final String KEY_MIN_RESTORE = "min_restore";
    public static final String KEY_MIN_RESTORE_BEST = "min_restore_best";
    double minProportion;

    public MinRestoreObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, String search, boolean lns) throws Exception {
        super(problem, timeLimit, verbose, maximize, search, lns);
        if (problem.getMinRestore() == null) {
            throw new Exception("MinRestoreObjective without minProportion is only allowed if a restorable constraint was posted");
        }
    }

    public MinRestoreObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize) throws Exception {
        this(problem, timeLimit, verbose, maximize, "", false);
    }

    public MinRestoreObjective(RestoptProblem problem, double minProportion, int timeLimit, boolean verbose, boolean maximize, String search, boolean lns) {
        super(problem, timeLimit, verbose, maximize, search, lns);
        this.minProportion = minProportion;
    }

    @Override
    public void initObjective() {
        if (this.problem.getMinRestore() != null) {
            this.objective = this.problem.getMinRestore();
        } else {
            double maxRest = Arrays.stream(this.problem.getData().getRestorableData()).filter(x -> !Double.isNaN(x)).sum();
            try {
                this.problem.postRestorableConstraint(0, (int)maxRest, this.minProportion);
                this.objective = this.problem.getMinRestore();
            }
            catch (RestoptException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getInitialValueMessage() {
        return "";
    }

    @Override
    public String[] getAdditionalKeys() {
        return new String[]{KEY_MIN_RESTORE, KEY_MIN_RESTORE_BEST};
    }

    @Override
    public Map<String, String> appendCharacteristics(Solution solution) {
        HashMap<String, String> charact = new HashMap<String, String>();
        charact.put(KEY_MIN_RESTORE, String.valueOf(solution.getIntVal(this.objective)));
        charact.put(KEY_MIN_RESTORE_BEST, String.valueOf(this.optimalValue));
        return charact;
    }

    @Override
    public List<String[]> appendMessages() {
        ArrayList<String[]> messages = new ArrayList<String[]>();
        messages.add(new String[]{KEY_MIN_RESTORE, "Min restore value: "});
        messages.add(new String[]{KEY_MIN_RESTORE_BEST, "Best known min restore value: "});
        return messages;
    }
}

