/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.limits.BacktrackCounter;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.limits.NodeCounter;
import org.chocosolver.solver.search.limits.RestartCounter;
import org.chocosolver.solver.search.limits.SolutionCounter;
import org.chocosolver.solver.search.limits.TimeCounter;
import org.chocosolver.solver.search.loop.monitors.NogoodFromRestarts;
import org.chocosolver.solver.search.loop.monitors.NogoodFromSolutions;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.criteria.Criterion;
import org.chocosolver.util.tools.TimeUtils;

public interface ISearchMonitorFactory
extends ISelf<Solver> {
    default public void setNoGoodRecordingFromSolutions(IntVar ... vars) {
        if (!((Solver)this.ref()).isLCG()) {
            ((Solver)this.ref()).plugMonitor(new NogoodFromSolutions(vars));
        }
    }

    default public void setNoGoodRecordingFromRestarts() {
        if (!((Solver)this.ref()).isLCG()) {
            ((Solver)this.ref()).plugMonitor(new NogoodFromRestarts(((Solver)this.ref()).getModel()));
        }
    }

    default public void limitSearch(Criterion aStopCriterion) {
        ((Solver)this.ref()).addStopCriterion(aStopCriterion);
    }

    default public void limitNode(long limit) {
        this.limitSearch(new NodeCounter(((Solver)this.ref()).getModel(), limit));
    }

    default public void limitFail(long limit) {
        this.limitSearch(new FailCounter(((Solver)this.ref()).getModel(), limit));
    }

    default public void limitBacktrack(long limit) {
        this.limitSearch(new BacktrackCounter(((Solver)this.ref()).getModel(), limit));
    }

    default public void limitSolution(long limit) {
        this.limitSearch(new SolutionCounter(((Solver)this.ref()).getModel(), limit));
    }

    default public void limitRestart(long limit) {
        this.limitSearch(new RestartCounter(((Solver)this.ref()).getModel(), limit));
    }

    default public void limitTime(long limit) {
        this.limitSearch(new TimeCounter(((Solver)this.ref()).getModel(), limit * 1000000L));
    }

    default public void limitTime(String duration) {
        this.limitTime(TimeUtils.convertInMilliseconds(duration));
    }

    default public void attach(Solution solution) {
        ((Solver)this.ref()).plugMonitor(solution::record);
    }
}

