/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.IterTuplesTable;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.constraints.extension.nary.TuplesLargeTable;
import org.chocosolver.solver.constraints.extension.nary.TuplesList;
import org.chocosolver.solver.constraints.extension.nary.TuplesTable;
import org.chocosolver.solver.constraints.extension.nary.TuplesVeryLargeTable;
import org.chocosolver.solver.variables.IntVar;

class RelationFactory {
    RelationFactory() {
    }

    public static LargeRelation makeLargeRelation(Tuples tuples, IntVar[] vars) {
        long totalSize = 1L;
        for (int i = 0; i < vars.length && (long)((int)totalSize) == totalSize; totalSize *= (long)vars[i].getRange(), ++i) {
        }
        if ((long)((int)totalSize) != totalSize) {
            return new TuplesVeryLargeTable(tuples, vars);
        }
        if (totalSize / 8L > 0x3200000L) {
            return new TuplesLargeTable(tuples, vars);
        }
        return new TuplesTable(tuples, vars);
    }

    public static IterTuplesTable makeIterableRelation(Tuples tuples, IntVar[] vars) {
        return new IterTuplesTable(tuples, vars);
    }

    public static TuplesList makeListBasedRelation(Tuples tuples, IntVar[] vars) {
        return new TuplesList(tuples, vars);
    }
}

