## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ordinalTables)

## ----dogs---------------------------------------------------------------------
print(dogs)

## ----kappa_dogs---------------------------------------------------------------
dogs_kappa <- kappa(dogs)
print(dogs_kappa)

## ----agresti_kappa------------------------------------------------------------
result <- Agresti_kappa_agreement(dogs)

## ----schuster_kappa-----------------------------------------------------------
result <- Schuster_symmetric_rater_agreement_model(vision_data)

## ----agresti_kappa_vision-----------------------------------------------------
result <- Agresti_kappa_agreement(vision_data)

## ----schuster_kappa_budget----------------------------------------------------
s_result <- Schuster_symmetric_rater_agreement_model(budget_actual)

## ----agresti_kappa_budget-----------------------------------------------------
a_result <- Agresti_kappa_agreement(budget_actual)

## ----stuart_budget------------------------------------------------------------
stuart_result <- Stuart_marginal_homogeneity(budget_actual)

## ----main_effects-------------------------------------------------------------
result <- von_Eye_main_effect(dogs)

## ----weight_response----------------------------------------------------------
result2 <- von_Eye_equal_weighted_diagonal(dogs)

## ----weights------------------------------------------------------------------
w <- c(3, 1, 1, 3)
x <- log_linear_main_effect_design(dogs)
x_prime <- log_linear_add_all_diagonals(dogs, x)
x_prime_prime <- von_Eye_weight_by_response_category_design(dogs, x_prime, w)
result3 <- log_linear_fit(dogs, x_prime_prime)

## ----all_diagonals------------------------------------------------------------
result4 <- von_Eye_diagonal(dogs)

## ----add linear_by_linear-----------------------------------------------------
linear <- log_linear_create_linear_by_linear(dogs, centered=TRUE)
print(linear)
x <- log_linear_main_effect_design(dogs)
x_new <- log_linear_append_column(x, linear)
print(x_new)
result5 <- log_linear_fit(dogs, x_new)

## ----von_Eye_linear_by_linear-------------------------------------------------
result5b <- von_Eye_linear_by_linear(dogs)

## ----agresti_rating_model-----------------------------------------------------
result6 <- von_Eye_diagonal_linear_by_linear(dogs)

## ----final_model--------------------------------------------------------------
x <- log_linear_equal_weight_agreement_design(dogs)
linear <- log_linear_create_linear_by_linear(dogs, centered=TRUE)
x_final <- log_linear_append_column(x, linear)
result8 <- log_linear_fit(dogs, x_final)

