/**
 * @file core/distances/distances.hpp
 * @author Ryan Curtin
 *
 * Include all distance metrics (e.g. distances in metric spaces that satisfy
 * the triangle inequality and formal definition of distance metric).  These are
 * useful for mlpack's tree-building code and other applications.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */
#ifndef MLPACK_CORE_DISTANCES_DISTANCES_HPP
#define MLPACK_CORE_DISTANCES_DISTANCES_HPP

#include "lmetric.hpp"
#include "mahalanobis_distance.hpp"
#include "ip_metric.hpp"
#include "iou_distance.hpp"

#endif
