## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----butterfly_count----------------------------------------------------------
library(butterfly)
butterflycount

## ----precipitation------------------------------------------------------------
forestprecipitation

## ----butterfly_example--------------------------------------------------------
butterfly::loupe(
  butterflycount$february,
  butterflycount$january,
  datetime_variable = "time"
)

butterfly::loupe(
  butterflycount$march,
  butterflycount$february,
  datetime_variable = "time"
)

## ----tolerance_example--------------------------------------------------------
butterfly::loupe(
  butterflycount$march,
  butterflycount$february,
  datetime_variable = "time",
  tolerance = 2 # <- setting a tolerance of 2
)

## ----butterfly_catch----------------------------------------------------------
df_caught <- butterfly::catch(
  butterflycount$march,
  butterflycount$february,
  datetime_variable = "time"
)

df_caught

## ----butterfly_release--------------------------------------------------------
df_released <- butterfly::release(
  butterflycount$march,
  butterflycount$february,
  datetime_variable = "time"
)

df_released

## ----butterfly_release_no_new_rows--------------------------------------------
df_release_without_new <- butterfly::release(
  butterflycount$march,
  butterflycount$february,
  datetime_variable = "time",
  include_new = FALSE
)

df_release_without_new


## ----rain_gauge_data----------------------------------------------------------
# A rain gauge which measures precipitation every day
butterfly::forestprecipitation$january

# In February there is a power failure in the instrument
butterfly::forestprecipitation$february

## ----check_continuity---------------------------------------------------------
butterfly::timeline(
   forestprecipitation$january,
   datetime_variable = "time",
   expected_lag = 1
 )

## ----not_continuous-----------------------------------------------------------
forestprecipitation$february

butterfly::timeline(
  forestprecipitation$february,
   datetime_variable = "time",
   expected_lag = 1
 )

## ----timeline_group-----------------------------------------------------------
butterfly::timeline_group(
  forestprecipitation$february,
   datetime_variable = "time",
   expected_lag = 1
 )

