/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import com.miraisolutions.xlconnect.utils.RepeatableIterable;
import java.util.Iterator;

public final class SequenceLengthEncoding
implements RepeatableIterable<Integer> {
    private final int[] values;
    private final int[] cumLengths;
    private final int increment;

    public SequenceLengthEncoding(int[] values, int[] lengths, int increment) {
        if (values.length != lengths.length) {
            throw new IllegalArgumentException("Arrays must be of same length");
        }
        for (int length : lengths) {
            if (length >= 1) continue;
            throw new IllegalArgumentException("Lengths must be greater than zero!");
        }
        this.values = values;
        this.cumLengths = SequenceLengthEncoding.cumulativeLengths(lengths);
        this.increment = increment;
    }

    @Override
    public Iterator<Integer> iterator(boolean repeating) {
        return new SequenceIterator(repeating);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.iterator(false);
    }

    @Override
    public int length() {
        return this.cumLengths[this.cumLengths.length - 1];
    }

    private static int[] cumulativeLengths(int[] lengths) {
        int[] cum = new int[lengths.length];
        int total = 0;
        for (int i = 0; i < lengths.length; ++i) {
            cum[i] = total += lengths[i];
        }
        return cum;
    }

    private final class SequenceIterator
    implements Iterator<Integer> {
        private final boolean repeating;
        private int i = 0;
        private int chunk = 0;

        public SequenceIterator(boolean repeating) {
            this.repeating = repeating;
        }

        private int elemsInPrevChunks() {
            return this.chunk == 0 ? 0 : SequenceLengthEncoding.this.cumLengths[this.chunk - 1];
        }

        @Override
        public boolean hasNext() {
            return this.repeating || this.i < SequenceLengthEncoding.this.length();
        }

        @Override
        public Integer next() {
            int result = SequenceLengthEncoding.this.values[this.chunk] + (this.i - this.elemsInPrevChunks()) * SequenceLengthEncoding.this.increment;
            ++this.i;
            if (this.repeating && this.i >= SequenceLengthEncoding.this.length()) {
                this.i = 0;
                this.chunk = 0;
            } else if (this.i >= SequenceLengthEncoding.this.cumLengths[this.chunk]) {
                ++this.chunk;
            }
            return result;
        }
    }
}

