#ifndef TTR_ENVIRONMENT
#define TTR_ENVIRONMENT

#include "RcppArmadillo.h"
#include <vector>
#include <type_traits>
#include <utility>
#include <iterator>
#include <array>
#include <algorithm>
#include <ParameterVector.hpp>
#include <definitions.hpp>

namespace ttr{
using std::vector;
using Range = std::pair<double, double>;
using namespace Rcpp;
using namespace arma;
// template<typename T>
// constexpr auto enum_option = _ParameterVector::option<T>;

struct environment{
  ParameterVector<Global> globals;

  //number of sites, implicit by data, dim(timeseries)[3]
  size_t nsites;
  //number of timesteps to perform, explicit in options, options$steps[length(options$steps)]
  size_t nsteps;
  //number of species, implicit by data, length(options$species)
  size_t nspecies;
  //number of timesteps to output, length(options$steps)
  size_t ntimeout;
  //number of steps in timeseries data dim(timeseries)[2]
  size_t ndata;

  constexpr static size_t nout = enum_count<Biotic>();

  //options
  TTRVariant var;
  std::vector<PhotoType> photos;
  //IntegerVector photos;
  IntegerVector steps;
  double initial_mass;
  double pe_scale;
  bool initial_mass_par;
  bool pe;

  environment(
      const arma::cube& timeseries,
      //const arma::mat& timeinvariant,
      const List& options,
      const NumericVector& globals_in);

};

}

#endif
