/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.utils;

import gov.nih.ncats.ifx.qhts.utils.Base64Converter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    public static Integer I = new Integer(1);
    public static HashMap monthMap;
    public static HashMap monthMap2;
    public static HashMap monthMap3;
    private static String[] patches;

    public static void main(String[] args) {
        try {
            Util.sscanf("");
            System.exit(1);
            String str = "2005-07-06 16:29:56.0";
            System.out.println(Util.oracleDateToSystemTime(str));
            str = "2005-07-06 16:30:56.0";
            String[] toks = Util.parseLineCSV("", ",");
            for (int i = 0; i < toks.length; ++i) {
                System.out.println(toks[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Util() {
    }

    public static double[] sscanf(String text) {
        text = "-79.842 -20.813-100.380 4.5 -5.6 7.8";
        StringTokenizer toks = new StringTokenizer(text, " -", true);
        ArrayList<String> list1 = new ArrayList<String>();
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (tok.equals(" ")) continue;
            if (tok.equals("-") && toks.hasMoreTokens()) {
                list1.add(tok + toks.nextToken());
            }
            list1.add(tok);
        }
        ArrayList list2 = new ArrayList();
        int i = 0;
        while (i < list1.size()) {
            if (((String)list1.get(i)).equals("-")) {
                ++i;
                continue;
            }
            list2.add(list1.get(i));
            ++i;
        }
        double[] ds = new double[list2.size()];
        for (i = 0; i < ds.length; ++i) {
            ds[i] = Double.parseDouble((String)list2.get(i));
            System.out.println(ds[i]);
        }
        return ds;
    }

    public static int countChar(String line, char ch) {
        int no = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != ch) continue;
            ++no;
        }
        return no;
    }

    public static String[] splitLine(String line, String del) {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        String row = line;
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int end = row.indexOf(del, start);
        while (end >= 0 && end <= row.length() - 1) {
            int no;
            String str = row.substring(start, end).trim();
            if (str.startsWith("\"")) {
                str = str.substring(1);
            }
            if (str.endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
            list.add(str);
            start = end + del.length();
            end = row.indexOf(del, start);
            boolean count = false;
            while (end >= 0 && end <= row.length() - 1 && (no = Util.countChar(str = row.substring(start, end).trim(), '\"')) % 2 != 0) {
                end = row.indexOf(del, end + 1);
            }
        }
        end = row.indexOf(del, start);
        if (end < 0) {
            list.add(row.substring(start).trim());
        } else {
            list.add(row.substring(start, end).trim());
        }
        String[] fields = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String value = (String)list.get(i);
            if (value.toLowerCase().equals("null")) {
                value = null;
                continue;
            }
            if (value.toLowerCase().equals("nan")) {
                value = null;
                continue;
            }
            fields[i] = value;
        }
        return fields;
    }

    public static String[] parseLineCSV(String line, String del) throws Exception {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        String row = line;
        ArrayList<String> list = new ArrayList<String>();
        boolean dqn = false;
        int start = 0;
        int end = row.indexOf(del, start);
        while (end >= 0 && end <= row.length() - 1) {
            String tok = row.substring(start, end).trim();
            if (tok.startsWith("\"") && (end = row.indexOf("\"", end + 1)) > 0) {
                tok = row.substring(start + 1, end).trim();
            }
            list.add(tok);
            start = end + del.length();
            end = row.indexOf(del, start);
        }
        end = row.indexOf(del, start);
        if (end < 0) {
            list.add(row.substring(start).trim());
        } else {
            list.add(row.substring(start, end).trim());
        }
        String[] fields = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String value = (String)list.get(i);
            if (value.toLowerCase().equals("null")) {
                value = null;
                continue;
            }
            if (value.toLowerCase().equals("nan")) {
                value = null;
                continue;
            }
            fields[i] = value;
        }
        return fields;
    }

    public static String[] parseLine(String line, String del) throws Exception {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        String row = line;
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int end = row.indexOf(del, start);
        while (end >= 0 && end <= row.length() - 1) {
            list.add(row.substring(start, end).trim());
            start = end + del.length();
            end = row.indexOf(del, start);
        }
        end = row.indexOf(del, start);
        if (end < 0) {
            list.add(row.substring(start).trim());
        } else {
            list.add(row.substring(start, end).trim());
        }
        String[] fields = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String value = (String)list.get(i);
            if (value.toLowerCase().equals("null")) {
                value = null;
                continue;
            }
            if (value.toLowerCase().equals("nan")) {
                value = null;
                continue;
            }
            fields[i] = value;
        }
        return fields;
    }

    public static HashMap calcWordMap(String[] rows, String del, String del2) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == null) continue;
            buffer.append(rows[i]);
            buffer.append(del);
        }
        StringTokenizer tokens = new StringTokenizer(buffer.toString(), del);
        while (tokens.hasMoreTokens()) {
            Object obj;
            String token = tokens.nextToken();
            int k = token.indexOf(del2);
            if (k > 0) {
                token = token.substring(0, k);
            }
            if ((obj = map.get(token)) == null) {
                map.put(token, new Integer(1));
                continue;
            }
            map.put(token, new Integer(1 + (Integer)obj));
        }
        return map;
    }

    public static HashMap row2map(String row) throws Exception {
        StringBuffer buffer = new StringBuffer(row);
        int count = 0;
        for (int j = 0; j < buffer.length(); ++j) {
            if (buffer.charAt(j) == '\"') {
                ++count;
            }
            if (count % 2 != 0 || buffer.charAt(j) != ' ') continue;
            buffer.setCharAt(j, ';');
        }
        StringTokenizer tokens = new StringTokenizer(buffer.toString(), ";");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            map.put(token, I);
        }
        return map;
    }

    public static String cleanText(String name, String pat) throws Exception {
        StringTokenizer tokens = new StringTokenizer(name, pat);
        StringBuffer buffer = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken());
        }
        return buffer.toString();
    }

    public static String cleanControl(String name) throws Exception {
        return name.replaceAll("[^\\x00-\\x7F]", "");
    }

    public static boolean isNumber(String text) throws Exception {
        text = Util.cleanText(text, " .,:;-_");
        boolean flag = true;
        for (int i = 0; i < text.length(); ++i) {
            flag &= Character.isDigit(text.charAt(i));
        }
        return flag;
    }

    public static ArrayList split(String line, String pat) throws Exception {
        int len = pat.length();
        String row = line;
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int end = row.indexOf(pat, start);
        while (end >= 0 && end <= row.length() - 1) {
            if (end > start) {
                list.add(row.substring(start + len, end).trim());
            }
            start = end + len;
            end = row.indexOf(pat, start);
        }
        if (end < 0) {
            list.add(row.substring(start).trim());
        } else {
            list.add(row.substring(start, end).trim());
        }
        return list;
    }

    public static String empty2null(String text) {
        if (text != null && text.trim().length() == 0) {
            return null;
        }
        return text;
    }

    public static Calendar julianToDate(double jd) {
        double a;
        Date date = new Date();
        double z = Math.floor(jd += 0.5);
        double f = jd - z;
        if (z >= 2299161.0) {
            a = Math.floor((z - 1867216.25) / 36524.25);
            a = z + 1.0 + a - Math.floor(a / 4.0);
        } else {
            a = z;
        }
        double b = a + 1524.0;
        double c = Math.floor((b - 122.1) / 365.25);
        double d = Math.floor(365.25 * c);
        double e = Math.floor((b - d) / 30.6001);
        double aux = b - d - Math.floor(30.6001 * e) + f;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(5, (int)aux);
        aux = (aux - (double)calendar.get(5)) * 24.0;
        calendar.set(11, (int)aux);
        calendar.set(12, (int)((aux - (double)calendar.get(11)) * 60.0));
        double m = e < 13.5 ? e - 1.0 : e - 13.0;
        calendar.set(2, (int)m - 1);
        if (m > 2.5) {
            calendar.set(1, (int)(c - 4716.0));
        } else {
            calendar.set(1, (int)(c - 4715.0));
        }
        return calendar;
    }

    public static String toDateString() {
        GregorianCalendar gDate = new GregorianCalendar();
        String year = String.valueOf(gDate.get(1));
        String month = "";
        int m = gDate.get(2) + 1;
        if (m < 10) {
            month = "0";
        }
        month = month + String.valueOf(m);
        String day = "";
        int d = gDate.get(5);
        if (d < 10) {
            day = "0";
        }
        day = day + String.valueOf(d);
        String dateString = month + "-" + day + "-" + year;
        return "to_date('" + dateString + "','MM-DD-YYYY')";
    }

    public static String toDateString(long date) {
        GregorianCalendar gDate = new GregorianCalendar();
        gDate.setTime(new Date(date));
        String year = String.valueOf(gDate.get(1));
        String month = "";
        int m = gDate.get(2) + 1;
        if (m < 10) {
            month = "0";
        }
        month = month + String.valueOf(m);
        String day = String.valueOf(gDate.get(5));
        String dateString = month + "-" + day + "-" + year;
        return "to_date('" + dateString + "','MM-DD-YYYY')";
    }

    public static int getMonth(String m) throws Exception {
        Integer M = (Integer)monthMap.get(m.toLowerCase());
        if (M == null) {
            return 0;
        }
        return M;
    }

    public static String getMonth2(String m) {
        return (String)monthMap2.get(m.toLowerCase());
    }

    public void getLocalTime() {
        GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance();
        cal.get(5);
        cal.get(1);
        cal.get(2);
    }

    public static String getLocalIP() throws Exception {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static void getByteUrlContent(String urlStr, String user, String password, String name) throws Exception {
        int size;
        byte[] buffer = new byte[1000000];
        FileOutputStream fos = new FileOutputStream(name);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        URL url = new URL(urlStr);
        URLConnection con = url.openConnection();
        if (user != null && password != null) {
            String login = user + ":" + password;
            String encoding = Base64Converter.encode(login.getBytes());
            con.setRequestProperty("Authorization", "Basic " + encoding);
        }
        con.setDoInput(true);
        con.setAllowUserInteraction(false);
        con.setDoOutput(false);
        boolean count = false;
        BufferedInputStream bin = new BufferedInputStream(con.getInputStream());
        while ((size = bin.read(buffer)) != -1) {
            bos.write(buffer, 0, size);
        }
        bin.close();
        fos.close();
        bos.close();
    }

    public static String formatSeq(String str) {
        StringBuffer buffer = new StringBuffer();
        int k = 0;
        k = str.length() % 60 == 0 ? str.length() / 60 : str.length() / 60 + 1;
        for (int i = 0; i < k; ++i) {
            int l = (i + 1) * 60;
            if (l > str.length()) {
                l = str.length();
            }
            buffer.append(str.substring(i * 60, l));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String escapeString(String str) {
        return str;
    }

    public static Object[] execCommand(String cmd) throws Exception {
        Object[] objects = new Object[3];
        Process process = null;
        process = Runtime.getRuntime().exec(cmd);
        process.waitFor();
        objects[0] = new Integer(process.exitValue());
        objects[1] = new String(Util.parseStream(process.getInputStream()));
        objects[2] = new String(Util.parseStream(process.getErrorStream()));
        process.destroy();
        return objects;
    }

    public static Object[] execCommand(String[] cmd) throws Exception {
        Object[] objects = new Object[3];
        Process process = null;
        process = Runtime.getRuntime().exec(cmd);
        process.waitFor();
        objects[0] = new Integer(process.exitValue());
        objects[1] = new String(Util.parseStream(process.getInputStream()));
        objects[2] = new String(Util.parseStream(process.getErrorStream()));
        process.destroy();
        return objects;
    }

    public static byte[] parseStream(InputStream sin) throws Exception {
        byte[] buffer;
        Integer Size = null;
        int size = 0;
        int total = 0;
        Vector<Integer> sizeVector = new Vector<Integer>();
        Vector<byte[]> bufferVector = new Vector<byte[]>();
        while ((size = sin.read(buffer = new byte[4096])) != -1) {
            sizeVector.addElement(new Integer(size));
            bufferVector.addElement(buffer);
        }
        sin.close();
        total = 0;
        for (int i = 0; i < sizeVector.size(); ++i) {
            Size = (Integer)sizeVector.elementAt(i);
            size = Size;
            total += size;
        }
        byte[] output = new byte[total];
        total = 0;
        for (int i = 0; i < sizeVector.size(); ++i) {
            Size = (Integer)sizeVector.elementAt(i);
            size = Size;
            byte[] buffer2 = (byte[])bufferVector.elementAt(i);
            System.arraycopy(buffer2, 0, output, total, size);
            total += size;
        }
        return output;
    }

    public static String formatDouble(double d, int left, int right) {
        String dString = String.valueOf(d);
        int pos = dString.indexOf(46);
        if (pos < 0) {
            return dString;
        }
        String leftString = dString.substring(0, pos);
        int delta = dString.length() - pos;
        String rightString = "";
        rightString = delta > right ? dString.substring(pos + 1, pos + 1 + right) : dString.substring(pos + 1);
        rightString = "." + rightString;
        delta = left - leftString.length();
        String patch = "";
        for (int i = 0; i < delta; ++i) {
            patch = patch + " ";
        }
        return patch + leftString + rightString;
    }

    public static String formatDouble(String ds, String pattern) {
        double d = Double.parseDouble(ds);
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(d);
        return output;
    }

    public static String formatDouble(double d, String pattern) {
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(d);
        return output;
    }

    public static String formatDouble(double d) {
        String pattern = "0.#####E0";
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        return myFormatter.format(d);
    }

    public static String formatDouble(double d, int right) {
        String pattern = "#0.";
        for (int i = 0; i < right; ++i) {
            pattern = pattern + "0";
        }
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(d);
        return output;
    }

    public static String formatSeq(String q0, String q1, String s0, String s1, String qSeq, String sSeq, String mSeq) {
        int qFrom = Integer.parseInt(q0);
        int qTo = Integer.parseInt(q1);
        int sFrom = Integer.parseInt(s0);
        int sTo = Integer.parseInt(s1);
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int end = 0;
        int len = qSeq.length() / 60 + 1;
        for (int i = 0; i < len; ++i) {
            int k = i * 60;
            int l = (i + 1) * 60;
            if (l > qSeq.length()) {
                l = qSeq.length();
            }
            if (qFrom < qTo) {
                start = qFrom + k;
                end = qFrom + l;
            } else {
                start = qFrom - k;
                end = qFrom - l;
            }
            buffer.append("Query:   ");
            buffer.append(Util.formatInteger(start, 10));
            buffer.append(qSeq.substring(k, l));
            buffer.append(" ");
            buffer.append(Util.formatInteger(end, 10));
            buffer.append("\n");
            buffer.append("         ");
            buffer.append("          ");
            buffer.append(mSeq.substring(k, l));
            buffer.append("\n");
            if (sFrom < sTo) {
                start = sFrom + k;
                end = sFrom + l;
            } else {
                start = sFrom - k;
                end = sFrom - l;
            }
            buffer.append("Subject: ");
            buffer.append(Util.formatInteger(start, 10));
            buffer.append(sSeq.substring(k, l));
            buffer.append(" ");
            buffer.append(Util.formatInteger(end, 10));
            buffer.append("\n");
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String formatInteger(int k, int n) {
        String str = String.valueOf(k);
        return str + patches[n - str.length()];
    }

    public static String capFirst(String txt) throws Exception {
        return txt.substring(0, 1).toUpperCase() + txt.substring(1).toLowerCase();
    }

    public static String capStr(String desc) {
        if (desc.equals("id")) {
            return "ID";
        }
        char c1 = desc.charAt(0);
        return Character.toUpperCase(c1) + desc.substring(1);
    }

    public static String toDesc(String desc) {
        return Util.desc(desc, true);
    }

    public static String toXmlDesc(String desc) {
        return Util.desc(desc, false);
    }

    public static String desc(String desc, boolean spaceFlag) {
        int k;
        String space = "";
        if (spaceFlag) {
            space = " ";
        }
        if ((k = desc.indexOf("_")) < 0) {
            return Util.capStr(desc);
        }
        int l = desc.indexOf("_", k + 1);
        if (l < 0) {
            String str1 = desc.substring(0, k);
            String str2 = desc.substring(k + 1);
            return Util.capStr(str1) + space + Util.capStr(str2);
        }
        String str1 = desc.substring(0, k);
        String str2 = desc.substring(k + 1, l);
        String str3 = desc.substring(l + 1);
        return Util.capStr(str1) + space + Util.capStr(str2) + space + Util.capStr(str3);
    }

    public static String[] parseTokens(String line, String del) throws Exception {
        StringTokenizer tokens = new StringTokenizer(line, del);
        String[] toks = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            toks[i] = tokens.nextToken();
            ++i;
        }
        return toks;
    }

    public static String parseBarcode(String name) {
        int k1 = name.indexOf(" ");
        int k2 = name.indexOf("-");
        int p = name.indexOf(".");
        if (k1 > 0 && k1 < p) {
            p = k1;
        }
        if (k2 > 0 && k2 < p) {
            p = k2;
        }
        String barcode = name.substring(0, p);
        return barcode;
    }

    public static String parseToken(String line, String pre, String suf) throws Exception {
        int k = line.indexOf(pre);
        if (k < 0) {
            return null;
        }
        int l = line.indexOf(suf, k + pre.length() + 1);
        if (l < 0) {
            return null;
        }
        return line.substring(k + pre.length(), l);
    }

    public static long oracleDateToSystemTime(String date) {
        StringTokenizer tokens = new StringTokenizer(date, "- :.");
        int year = Integer.parseInt(tokens.nextToken());
        int month = Integer.parseInt(tokens.nextToken()) - 1;
        int day = Integer.parseInt(tokens.nextToken());
        int hour = Integer.parseInt(tokens.nextToken());
        int min = Integer.parseInt(tokens.nextToken());
        int sec = Integer.parseInt(tokens.nextToken());
        System.out.println(year + ":" + month + ":" + day + ":" + hour + ":" + min + ":" + sec);
        GregorianCalendar gc = new GregorianCalendar(year, month, day, hour, min, sec);
        return gc.getTimeInMillis() / 1000L;
    }

    static {
        patches = new String[10];
        for (int i = 1; i < 10; ++i) {
            Util.patches[i] = new String();
            for (int j = 0; j < i; ++j) {
                Util.patches[i] = patches[i] + " ";
            }
        }
        monthMap = new HashMap();
        monthMap.put("jan", new Integer(1));
        monthMap.put("feb", new Integer(2));
        monthMap.put("mar", new Integer(3));
        monthMap.put("apr", new Integer(4));
        monthMap.put("may", new Integer(5));
        monthMap.put("jun", new Integer(6));
        monthMap.put("jul", new Integer(7));
        monthMap.put("aug", new Integer(8));
        monthMap.put("sep", new Integer(9));
        monthMap.put("oct", new Integer(10));
        monthMap.put("nov", new Integer(11));
        monthMap.put("dec", new Integer(12));
        monthMap2 = new HashMap();
        monthMap2.put("jan", "1");
        monthMap2.put("feb", "2");
        monthMap2.put("mar", "3");
        monthMap2.put("apr", "4");
        monthMap2.put("may", "5");
        monthMap2.put("jun", "6");
        monthMap2.put("jul", "7");
        monthMap2.put("aug", "8");
        monthMap2.put("sep", "9");
        monthMap2.put("oct", "10");
        monthMap2.put("nov", "11");
        monthMap2.put("dec", "12");
        monthMap3 = new HashMap();
        monthMap3.put("jan", "01");
        monthMap3.put("feb", "02");
        monthMap3.put("mar", "03");
        monthMap3.put("apr", "04");
        monthMap3.put("may", "05");
        monthMap3.put("jun", "06");
        monthMap3.put("jul", "07");
        monthMap3.put("aug", "08");
        monthMap3.put("sep", "09");
        monthMap3.put("oct", "10");
        monthMap3.put("nov", "11");
        monthMap3.put("dec", "12");
    }
}

