/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.Timer;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatFactory3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;

public class BenchmarkFloatFFT {
    private static final int[] sizes2D = new int[]{16000, 16384};
    private static final int[] sizes3D = new int[]{100, 128, 200, 256, 500, 512};
    private static int niters = 100;

    public static void benchmarkFft2() {
        Timer timer = new Timer();
        double[] dArray = new double[sizes2D.length];
        for (int i = 0; i < sizes2D.length; ++i) {
            int n;
            DenseFloatMatrix2D denseFloatMatrix2D = (DenseFloatMatrix2D)FloatFactory2D.dense.make(sizes2D[i], sizes2D[i]);
            DenseFComplexMatrix2D denseFComplexMatrix2D = denseFloatMatrix2D.getFft2();
            denseFComplexMatrix2D = denseFloatMatrix2D.getFft2();
            timer.reset().start();
            for (n = 0; n < niters; ++n) {
                denseFComplexMatrix2D = denseFloatMatrix2D.getFft2();
            }
            timer.stop();
            dArray[i] = timer.millis() / (double)niters;
            n = sizes2D[i] * sizes2D[i];
            double d = 2.5 * (double)n * BenchmarkFloatFFT.log2(n) / (double)(timer.nanos() / (long)niters);
            System.out.println("Average execution time for single precision getFft2() of size " + sizes2D[i] + " x " + sizes2D[i] + " : " + dArray[i] + " ms");
            System.out.println("Performance of single precision getFft2() of size " + sizes2D[i] + " x " + sizes2D[i] + " : " + String.format("%.4f", d) + " gflops");
        }
    }

    public static double log2(double d) {
        return Math.log10(d) / Math.log10(2.0);
    }

    public static void benchmarkFft3() {
        Timer timer = new Timer();
        double[] dArray = new double[sizes3D.length];
        for (int i = 0; i < sizes3D.length; ++i) {
            int n;
            DenseFloatMatrix3D denseFloatMatrix3D = (DenseFloatMatrix3D)FloatFactory3D.dense.make(sizes3D[i], sizes3D[i], sizes3D[i]);
            DenseFComplexMatrix3D denseFComplexMatrix3D = denseFloatMatrix3D.getFft3();
            denseFComplexMatrix3D = denseFloatMatrix3D.getFft3();
            timer.reset().start();
            for (n = 0; n < niters; ++n) {
                denseFComplexMatrix3D = denseFloatMatrix3D.getFft3();
            }
            timer.stop();
            dArray[i] = timer.millis() / (double)niters;
            n = sizes3D[i] * sizes3D[i] * sizes3D[i];
            double d = 2.5 * (double)n * BenchmarkFloatFFT.log2(n) / (double)(timer.nanos() / (long)niters);
            System.out.println("Average execution time for single precision getFft3() of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + " : " + dArray[i] + " ms");
            System.out.println("Performance of single precision getFft3() of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + " : " + String.format("%.4f", d) + " gflops");
        }
    }

    public static void main(String[] stringArray) {
        BenchmarkFloatFFT.benchmarkFft2();
    }
}

