/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatLongProcedure;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractFloatLongMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractFloatLongMap() {
    }

    public boolean containsKey(final float f) {
        return !this.forEachKey(new FloatProcedure(){

            public boolean apply(float f2) {
                return f != f2;
            }
        });
    }

    public boolean containsValue(final long l) {
        return !this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float f, long l2) {
                return l != l2;
            }
        });
    }

    public AbstractFloatLongMap copy() {
        return (AbstractFloatLongMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractFloatLongMap)) {
            return false;
        }
        final AbstractFloatLongMap abstractFloatLongMap = (AbstractFloatLongMap)object;
        if (abstractFloatLongMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float f, long l) {
                return abstractFloatLongMap.containsKey(f) && abstractFloatLongMap.get(f) == l;
            }
        }) && abstractFloatLongMap.forEachPair(new FloatLongProcedure(){

            public boolean apply(float f, long l) {
                return AbstractFloatLongMap.this.containsKey(f) && AbstractFloatLongMap.this.get(f) == l;
            }
        });
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatLongProcedure floatLongProcedure) {
        return this.forEachKey(new FloatProcedure(){

            public boolean apply(float f) {
                return floatLongProcedure.apply(f, AbstractFloatLongMap.this.get(f));
            }
        });
    }

    public abstract long get(float var1);

    public float keyOf(final long l) {
        final float[] fArray = new float[1];
        boolean bl = this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float f, long l2) {
                boolean bl;
                boolean bl2 = bl = l == l2;
                if (bl) {
                    fArray[0] = f;
                }
                return !bl;
            }
        });
        if (bl) {
            return Float.NaN;
        }
        return fArray[0];
    }

    public FloatArrayList keys() {
        FloatArrayList floatArrayList = new FloatArrayList(this.size());
        this.keys(floatArrayList);
        return floatArrayList;
    }

    public void keys(final FloatArrayList floatArrayList) {
        floatArrayList.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float f) {
                floatArrayList.add(f);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList floatArrayList) {
        this.pairsSortedByValue(floatArrayList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final FloatLongProcedure floatLongProcedure, final FloatArrayList floatArrayList, final LongArrayList longArrayList) {
        floatArrayList.clear();
        longArrayList.clear();
        this.forEachPair(new FloatLongProcedure(){

            public boolean apply(float f, long l) {
                if (floatLongProcedure.apply(f, l)) {
                    floatArrayList.add(f);
                    longArrayList.add(l);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList floatArrayList, LongArrayList longArrayList) {
        this.keys(floatArrayList);
        floatArrayList.sort();
        longArrayList.setSize(floatArrayList.size());
        int n = floatArrayList.size();
        while (--n >= 0) {
            longArrayList.setQuick(n, this.get(floatArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(FloatArrayList floatArrayList, LongArrayList longArrayList) {
        this.keys(floatArrayList);
        this.values(longArrayList);
        final float[] fArray = floatArrayList.elements();
        final long[] lArray = longArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return lArray[n] < lArray[n2] ? -1 : (lArray[n] > lArray[n2] ? 1 : (fArray[n] < fArray[n2] ? -1 : (fArray[n] == fArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, floatArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(float var1, long var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList floatArrayList = this.keys();
        floatArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = floatArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            float f = floatArrayList.get(i);
            stringBuffer.append(String.valueOf(f));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(f)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        FloatArrayList floatArrayList = new FloatArrayList();
        this.keysSortedByValue(floatArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = floatArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            float f = floatArrayList.get(i);
            stringBuffer.append(String.valueOf(f));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(f)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public LongArrayList values() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.values(longArrayList);
        return longArrayList;
    }

    public void values(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float f) {
                longArrayList.add(AbstractFloatLongMap.this.get(f));
                return true;
            }
        });
    }
}

