/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.model.Parameter;

public interface MassPreconditioningOptions {
    public int preconditioningUpdateFrequency();

    public int preconditioningDelay();

    public int preconditioningMaxUpdate();

    public int preconditioningMemory();

    public Parameter preconditioningEigenLowerBound();

    public Parameter preconditioningEigenUpperBound();

    public static class Default
    implements MassPreconditioningOptions {
        final int preconditioningUpdateFrequency;
        final int preconditioningMaxUpdate;
        final int preconditioningDelay;
        final int preconditioningMemory;
        final boolean guessInitialMass;
        final Parameter preconditioningEigenLowerBound;
        final Parameter preconditioningEigenUpperBound;

        public Default(int preconditioningUpdateFrequency, int preconditioningMaxUpdate, int preconditioningDelay, int preconditioningMemory, boolean guessInitialMass, Parameter eigenLowerBound, Parameter eigenUpperBound) {
            this.preconditioningUpdateFrequency = preconditioningUpdateFrequency;
            this.preconditioningMaxUpdate = preconditioningMaxUpdate;
            this.preconditioningDelay = preconditioningDelay;
            this.preconditioningMemory = preconditioningMemory;
            this.guessInitialMass = guessInitialMass;
            this.preconditioningEigenLowerBound = eigenLowerBound;
            this.preconditioningEigenUpperBound = eigenUpperBound;
        }

        @Override
        public int preconditioningUpdateFrequency() {
            return this.preconditioningUpdateFrequency;
        }

        @Override
        public int preconditioningDelay() {
            return this.preconditioningDelay;
        }

        @Override
        public int preconditioningMaxUpdate() {
            return this.preconditioningMaxUpdate;
        }

        @Override
        public int preconditioningMemory() {
            return this.preconditioningMemory;
        }

        @Override
        public Parameter preconditioningEigenLowerBound() {
            return this.preconditioningEigenLowerBound;
        }

        @Override
        public Parameter preconditioningEigenUpperBound() {
            return this.preconditioningEigenUpperBound;
        }
    }
}

