/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public class RQ
extends OrthogonalComputer {
    public RQ(int m, int n) {
        super(m, n, true);
        if (n < m) {
            throw new IllegalArgumentException("n < m");
        }
        this.work = new double[1];
        int info = Interface.lapack().gerqf(m, n, new double[0], new double[0], this.work, -1);
        int lwork = info != 0 ? m : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = Interface.lapack().orgrq(m, n, m, new double[0], new double[0], this.workGen, -1);
        lwork = info != 0 ? m : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static RQ factorize(Matrix A) {
        return new RQ(A.numRows(), A.numColumns()).factor(new DenseMatrix(A));
    }

    public RQ factor(DenseMatrix A) {
        if (this.Q.numRows() != A.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.R == null) {
            throw new IllegalArgumentException("R == null");
        }
        int info = Interface.lapack().gerqf(this.m, this.n, A.getData(), this.tau, this.work, this.work.length);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        this.R.zero();
        for (MatrixEntry e : A) {
            if (e.column() < this.n - this.m + e.row()) continue;
            this.R.set(e.row(), e.column() - (this.n - this.m), e.get());
        }
        info = Interface.lapack().orgrq(this.m, this.n, this.k, A.getData(), this.tau, this.workGen, this.workGen.length);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A);
        return this;
    }

    public UpperTriangDenseMatrix getR() {
        return this.R;
    }
}

