/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractSymmDenseMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class LowerSymmDenseMatrix
extends AbstractSymmDenseMatrix {
    public LowerSymmDenseMatrix(int n) {
        super(n, BLASkernel.UpLo.Lower);
    }

    public LowerSymmDenseMatrix(Matrix A) {
        this(A, true);
    }

    public LowerSymmDenseMatrix(Matrix A, boolean deep) {
        super(A, deep, BLASkernel.UpLo.Lower);
    }

    public void add(int row, int column, double value) {
        if (column <= row) {
            super.add(row, column, value);
        }
    }

    public double get(int row, int column) {
        if (column > row) {
            return super.get(column, row);
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (column <= row) {
            super.set(row, column, value);
        }
    }

    public LowerSymmDenseMatrix copy() {
        return new LowerSymmDenseMatrix(this);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() < e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }
}

